/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.sources;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ignite.internal.metrics.LongGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;
import org.jetbrains.annotations.Nullable;

public class JvmMetricSource
implements MetricSource {
    private static final String SOURCE_NAME = "jvm";
    private static final long MEMORY_USAGE_CACHE_TIMEOUT = 1000L;
    private final MemoryMXBean memoryMxBean;
    private final List<GarbageCollectorMXBean> gcMxBeans;
    private boolean enabled;

    JvmMetricSource(MemoryMXBean memoryMxBean, List<GarbageCollectorMXBean> gcMxBeans) {
        this.memoryMxBean = memoryMxBean;
        this.gcMxBeans = List.copyOf(gcMxBeans);
    }

    public JvmMetricSource() {
        this.memoryMxBean = ManagementFactory.getMemoryMXBean();
        this.gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
    }

    @Override
    public String name() {
        return SOURCE_NAME;
    }

    @Override
    @Nullable
    public synchronized MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        CachedMemoryUsage heapMemoryUsage = new CachedMemoryUsage(this.memoryMxBean::getHeapMemoryUsage, 1000L);
        metrics.put("memory.heap.Init", new LongGauge("memory.heap.Init", "Initial amount of heap memory", () -> heapMemoryUsage.get().getInit()));
        metrics.put("memory.heap.Used", new LongGauge("memory.heap.Used", "Current used amount of heap memory", () -> heapMemoryUsage.get().getUsed()));
        metrics.put("memory.heap.Committed", new LongGauge("memory.heap.Committed", "Committed amount of heap memory", () -> heapMemoryUsage.get().getCommitted()));
        metrics.put("memory.heap.Max", new LongGauge("memory.heap.Max", "Maximum amount of heap memory", () -> heapMemoryUsage.get().getMax()));
        CachedMemoryUsage nonHeapMemoryUsage = new CachedMemoryUsage(this.memoryMxBean::getNonHeapMemoryUsage, 1000L);
        metrics.put("memory.non-heap.Init", new LongGauge("memory.non-heap.Init", "Initial amount of non-heap memory", () -> nonHeapMemoryUsage.get().getInit()));
        metrics.put("memory.non-heap.Used", new LongGauge("memory.non-heap.Used", "Used amount of non-heap memory", () -> nonHeapMemoryUsage.get().getUsed()));
        metrics.put("memory.non-heap.Committed", new LongGauge("memory.non-heap.Committed", "Committed amount of non-heap memory", () -> nonHeapMemoryUsage.get().getCommitted()));
        metrics.put("memory.non-heap.Max", new LongGauge("memory.non-heap.Max", "Maximum amount of non-heap memory", () -> nonHeapMemoryUsage.get().getMax()));
        metrics.put("gc.CollectionTime", new LongGauge("gc.CollectionTime", "Approximate total time spent on garbage collection in milliseconds, summed across all collectors.", this::totalCollectionTime));
        this.enabled = true;
        return new MetricSet(SOURCE_NAME, metrics);
    }

    private long totalCollectionTime() {
        long total = 0L;
        for (GarbageCollectorMXBean gcMxBean : this.gcMxBeans) {
            long time = gcMxBean.getCollectionTime();
            if (time <= 0L) continue;
            total += time;
        }
        return total;
    }

    @Override
    public synchronized void disable() {
        this.enabled = false;
    }

    @Override
    public synchronized boolean enabled() {
        return this.enabled;
    }

    private static class CachedMemoryUsage {
        private final Supplier<MemoryUsage> source;
        private final long timeout;
        private volatile long lastUpdateTime;
        private volatile MemoryUsage currentVal;

        private CachedMemoryUsage(Supplier<MemoryUsage> source, long timeout) {
            this.source = source;
            this.timeout = timeout;
            this.update();
        }

        private MemoryUsage get() {
            if (System.currentTimeMillis() - this.lastUpdateTime > this.timeout) {
                this.update();
            }
            return this.currentVal;
        }

        private synchronized void update() {
            this.currentVal = this.source.get();
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

