/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.table.TupleImpl;
import org.jetbrains.annotations.Nullable;

public interface Tuple
extends Iterable<Object> {
    public static Tuple create() {
        return new TupleImpl();
    }

    public static Tuple create(int capacity) {
        return new TupleImpl(capacity);
    }

    public static Tuple create(Map<String, Object> map) {
        TupleImpl tuple = new TupleImpl(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            tuple.set(entry.getKey(), entry.getValue());
        }
        return tuple;
    }

    public static Tuple copy(Tuple tuple) {
        return new TupleImpl(tuple);
    }

    public static int hashCode(Tuple tuple) {
        int hash = 0;
        for (int idx = 0; idx < tuple.columnCount(); ++idx) {
            String columnName = tuple.columnName(idx);
            Object columnValue = tuple.value(idx);
            int columnValueHash = 0;
            if (columnValue != null) {
                columnValueHash = columnValue instanceof byte[] ? Arrays.hashCode((byte[])columnValue) : columnValue.hashCode();
            }
            hash += columnName.hashCode() ^ columnValueHash;
        }
        return hash;
    }

    public int hashCode();

    public static boolean equals(Tuple firstTuple, Tuple secondTuple) {
        if (firstTuple == secondTuple) {
            return true;
        }
        int columns = firstTuple.columnCount();
        if (columns != secondTuple.columnCount()) {
            return false;
        }
        for (int idx = 0; idx < columns; ++idx) {
            Object secondVal;
            int idx2 = secondTuple.columnIndex(firstTuple.columnName(idx));
            if (idx2 < 0) {
                return false;
            }
            Object firstVal = firstTuple.value(idx);
            if (Objects.deepEquals(firstVal, secondVal = secondTuple.value(idx2))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object var1);

    public int columnCount();

    public String columnName(int var1);

    public int columnIndex(String var1);

    @Nullable
    public <T> T valueOrDefault(String var1, @Nullable T var2);

    public Tuple set(String var1, @Nullable Object var2);

    @Nullable
    public <T> T value(String var1) throws IllegalArgumentException;

    @Nullable
    public <T> T value(int var1);

    public boolean booleanValue(String var1);

    public boolean booleanValue(int var1);

    public byte byteValue(String var1);

    public byte byteValue(int var1);

    public short shortValue(String var1);

    public short shortValue(int var1);

    public int intValue(String var1);

    public int intValue(int var1);

    public long longValue(String var1);

    public long longValue(int var1);

    public float floatValue(String var1);

    public float floatValue(int var1);

    public double doubleValue(String var1);

    public double doubleValue(int var1);

    public BigDecimal decimalValue(String var1);

    public BigDecimal decimalValue(int var1);

    public String stringValue(String var1);

    public String stringValue(int var1);

    public UUID uuidValue(String var1);

    public UUID uuidValue(int var1);

    public LocalDate dateValue(String var1);

    public LocalDate dateValue(int var1);

    public LocalTime timeValue(String var1);

    public LocalTime timeValue(int var1);

    public LocalDateTime datetimeValue(String var1);

    public LocalDateTime datetimeValue(int var1);

    public Instant timestampValue(String var1);

    public Instant timestampValue(int var1);

    @Override
    default public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int cur;

            @Override
            public boolean hasNext() {
                return this.cur < Tuple.this.columnCount();
            }

            @Override
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Tuple.this.value(this.cur++);
            }
        };
    }
}

