/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.property;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.sql.engine.property.BuilderImpl;
import org.apache.ignite.internal.sql.engine.property.Property;
import org.apache.ignite.internal.sql.engine.property.SqlProperties;
import org.apache.ignite.internal.sql.engine.property.SqlPropertiesImpl;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.FilteringIterator;
import org.apache.ignite.internal.util.IgniteUtils;

public final class SqlPropertiesHelper {
    private SqlPropertiesHelper() {
        throw new IllegalStateException();
    }

    public static SqlProperties emptyProperties() {
        return new SqlPropertiesImpl(Map.of());
    }

    public static SqlProperties.Builder newBuilder() {
        return new BuilderImpl();
    }

    public static SqlProperties merge(SqlProperties primary, SqlProperties secondary) {
        SqlProperties.Builder builder = SqlPropertiesHelper.builderFromProperties(secondary);
        for (Map.Entry entry : primary) {
            builder.set((Property)entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static SqlProperties chain(SqlProperties primary, SqlProperties secondary) {
        return new ChainedSqlProperties(primary, secondary);
    }

    public static SqlProperties.Builder builderFromProperties(SqlProperties holder) {
        BuilderImpl builder = new BuilderImpl();
        for (Map.Entry e : holder) {
            builder.set((Property)e.getKey(), e.getValue());
        }
        return builder;
    }

    public static Map<String, Property<?>> createPropsByNameMap(Class<?> cls) {
        List properties = IgniteUtils.collectStaticFields(cls, Property.class);
        HashMap<String, Property> tmp = new HashMap<String, Property>();
        for (Property property : properties) {
            tmp.put(property.name, property);
        }
        return Map.copyOf(tmp);
    }

    private static class ChainedSqlProperties
    implements SqlProperties {
        private final SqlProperties primary;
        private final SqlProperties secondary;

        private ChainedSqlProperties(SqlProperties primary, SqlProperties secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public <T> T get(Property<T> prop) {
            if (this.primary.hasProperty(prop)) {
                return this.primary.get(prop);
            }
            return this.secondary.get(prop);
        }

        @Override
        public <T> T getOrDefault(Property<T> prop, T defaultValue) {
            if (this.primary.hasProperty(prop)) {
                return this.primary.get(prop);
            }
            return this.secondary.getOrDefault(prop, defaultValue);
        }

        @Override
        public boolean hasProperty(Property<?> prop) {
            return this.primary.hasProperty(prop) || this.secondary.hasProperty(prop);
        }

        @Override
        public Iterator<Map.Entry<Property<?>, Object>> iterator() {
            return CollectionUtils.concat((Iterator[])new Iterator[]{this.primary.iterator(), new FilteringIterator(this.secondary.iterator(), entry -> !this.primary.hasProperty((Property)entry.getKey()))});
        }
    }
}

