/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.rel.AbstractIgniteSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;

public class IgniteTableSpool
extends AbstractIgniteSpool {
    private static final String REL_TYPE_NAME = "TableSpool";

    public IgniteTableSpool(RelOptCluster cluster, RelTraitSet traits, Spool.Type readType, RelNode input) {
        super(cluster, traits, readType, input);
    }

    public IgniteTableSpool(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), (Spool.Type)input.getEnum("readType", Spool.Type.class), input.getInput());
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteTableSpool(cluster, this.getTraitSet(), this.readType, (RelNode)inputs.get(0));
    }

    protected Spool copy(RelTraitSet traitSet, RelNode input, Spool.Type readType, Spool.Type writeType) {
        return new IgniteTableSpool(this.getCluster(), traitSet, readType, input);
    }

    public boolean isEnforcer() {
        return true;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCnt = mq.getRowCount(this.getInput());
        double bytesPerRow = (double)this.getRowType().getFieldCount() * 4.0;
        double totalBytes = rowCnt * bytesPerRow;
        double cpuCost = rowCnt * 1.0;
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        return costFactory.makeCost(rowCnt, cpuCost, 0.0, totalBytes, 0.0);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }
}

