/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.schema.AbstractIgniteDataSource;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class IgniteTableImpl
extends AbstractIgniteDataSource
implements IgniteTable {
    private final ImmutableIntList keyColumns;
    @Nullable
    private final ImmutableBitSet columnsToInsert;
    @Nullable
    private final ImmutableBitSet columnsToUpdate;
    private final Map<String, IgniteIndex> indexMap;
    private final int partitions;
    private final Lazy<NativeType[]> colocationColumnTypes;

    public IgniteTableImpl(String name, int id, int version, TableDescriptor desc, ImmutableIntList keyColumns, Statistic statistic, Map<String, IgniteIndex> indexMap, int partitions) {
        super(name, id, version, desc, statistic);
        this.keyColumns = keyColumns;
        this.indexMap = indexMap;
        this.partitions = partitions;
        this.columnsToInsert = IgniteTableImpl.deriveColumnsToInsert(desc);
        int virtualColumnsCount = (int)StreamSupport.stream(desc.spliterator(), false).filter(ColumnDescriptor::virtual).count();
        this.columnsToUpdate = ImmutableBitSet.range((int)(desc.columnsCount() - virtualColumnsCount));
        this.colocationColumnTypes = new Lazy(this::evaluateTypes);
    }

    private static RelDataType deriveDeleteRowType(IgniteTypeFactory typeFactory, TableDescriptor desc, ImmutableIntList keyColumns) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        RelDataType fullRow = desc.rowType(typeFactory, null);
        Iterator iterator = keyColumns.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            builder.add((RelDataTypeField)fullRow.getFieldList().get(i));
        }
        return builder.build();
    }

    @Nullable
    private static ImmutableBitSet deriveColumnsToInsert(TableDescriptor desc) {
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        boolean hiddenColumnFound = false;
        for (ColumnDescriptor columnDescriptor : desc) {
            if (columnDescriptor.hidden()) {
                hiddenColumnFound = true;
                continue;
            }
            builder.set(columnDescriptor.logicalIndex());
        }
        if (hiddenColumnFound) {
            return builder.build();
        }
        return null;
    }

    @Override
    public Supplier<PartitionCalculator> partitionCalculator() {
        return () -> new PartitionCalculator(this.partitions, Objects.requireNonNull((NativeType[])this.colocationColumnTypes.get()));
    }

    private NativeType[] evaluateTypes() {
        int fieldCnt = this.descriptor().distribution().getKeys().size();
        NativeType[] fieldTypes = new NativeType[fieldCnt];
        int[] colocationColumns = this.descriptor().distribution().getKeys().toIntArray();
        for (int i = 0; i < fieldCnt; ++i) {
            ColumnDescriptor colDesc = this.descriptor().columnDescriptor(colocationColumns[i]);
            fieldTypes[i] = colDesc.physicalType();
        }
        return fieldTypes;
    }

    @Override
    public Map<String, IgniteIndex> indexes() {
        return this.indexMap;
    }

    @Override
    public int partitions() {
        return this.partitions;
    }

    @Override
    public ImmutableIntList keyColumns() {
        return this.keyColumns;
    }

    @Override
    protected TableScan toRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable relOptTbl, List<RelHint> hints) {
        return IgniteLogicalTableScan.create(cluster, traitSet, hints, relOptTbl, null, null, null);
    }

    @Override
    public boolean isUpdateAllowed(int colIdx) {
        ColumnDescriptor columnDescriptor = this.descriptor().columnDescriptor(colIdx);
        return !columnDescriptor.key() && !columnDescriptor.virtual();
    }

    @Override
    public RelDataType rowTypeForInsert(IgniteTypeFactory factory) {
        return this.descriptor().rowType(factory, this.columnsToInsert);
    }

    @Override
    public RelDataType rowTypeForUpdate(IgniteTypeFactory factory) {
        return this.descriptor().rowType(factory, this.columnsToUpdate);
    }

    @Override
    public RelDataType rowTypeForDelete(IgniteTypeFactory factory) {
        return IgniteTableImpl.deriveDeleteRowType(factory, this.descriptor(), this.keyColumns);
    }
}

