/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import org.apache.ignite.internal.table.distributed.BitSetPartitionSet;
import org.apache.ignite.internal.tostring.S;

public interface PartitionSet {
    public static final PartitionSet EMPTY_SET = new PartitionSet(){

        @Override
        public void set(int partitionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear(int partitionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean get(int partitionId) {
            return false;
        }

        @Override
        public IntStream stream() {
            return IntStream.empty();
        }

        @Override
        public PartitionSet copy() {
            return new BitSetPartitionSet();
        }

        @Override
        public int size() {
            return 0;
        }

        public int hashCode() {
            return this.getHashCode();
        }

        public boolean equals(Object obj) {
            return this.isEqual(obj);
        }

        public String toString() {
            return "PartitionSet(empty)";
        }
    };

    public void set(int var1);

    public void clear(int var1);

    public boolean get(int var1);

    public IntStream stream();

    public int size();

    public PartitionSet copy();

    default public boolean isEqual(Object another) {
        if (!(another instanceof PartitionSet)) {
            return false;
        }
        PartitionSet anotherSet = (PartitionSet)another;
        if (this.size() != anotherSet.size()) {
            return false;
        }
        PrimitiveIterator.OfInt iterator1 = this.stream().iterator();
        PrimitiveIterator.OfInt iterator2 = anotherSet.stream().iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (iterator1.nextInt() == iterator2.nextInt()) continue;
            return false;
        }
        return true;
    }

    default public int getHashCode() {
        int h = 0;
        PrimitiveIterator.OfInt iter = this.stream().iterator();
        while (iter.hasNext()) {
            int idx = iter.nextInt();
            h += idx;
        }
        return h;
    }

    public static PartitionSet of(final int partId) {
        return new PartitionSet(){

            @Override
            public void set(int partitionId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear(int partitionId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean get(int partitionId) {
                return partitionId == partId;
            }

            @Override
            public IntStream stream() {
                return IntStream.of(partId);
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public PartitionSet copy() {
                return PartitionSet.of(partId);
            }

            public int hashCode() {
                return this.getHashCode();
            }

            public boolean equals(Object o) {
                return this.isEqual(o);
            }

            public String toString() {
                return S.toString(PartitionSet.class, (Object)this, (String)("partitionId=" + partId));
            }
        };
    }
}

