/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.message.JobStatesResponse;
import org.apache.ignite.internal.compute.message.JobStatesResponseBuilder;
import org.apache.ignite.internal.compute.message.JobStatesResponseSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class JobStatesResponseImpl
implements JobStatesResponse,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 12;
    @IgniteToStringInclude
    private Collection<JobState> states;
    private byte[] statesByteArray;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;

    private JobStatesResponseImpl(Collection<JobState> states, byte[] statesByteArray, Throwable throwable, byte[] throwableByteArray) {
        this.states = states;
        this.statesByteArray = statesByteArray;
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
    }

    byte[] statesByteArray() {
        return this.statesByteArray;
    }

    @Override
    public Collection<JobState> states() {
        return this.states;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    public MessageSerializer serializer() {
        return JobStatesResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobStatesResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 12;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobStatesResponseImpl otherMessage = (JobStatesResponseImpl)other;
        return Objects.equals(this.states, otherMessage.states) && Objects.equals(this.throwable, otherMessage.throwable);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.states, this.throwable);
        return result;
    }

    public JobStatesResponseImpl clone() {
        try {
            return (JobStatesResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobStatesResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject statesByteArraymo = marshaller.marshal(this.states);
        usedDescriptors.addAll((IntCollection)statesByteArraymo.usedDescriptorIds());
        this.statesByteArray = statesByteArraymo.bytes();
        MarshalledObject throwableByteArraymo = marshaller.marshal((Object)this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.states = (Collection)marshaller.unmarshal(this.statesByteArray, descriptorsObj);
        this.statesByteArray = null;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements JobStatesResponseBuilder {
        private Collection<JobState> states;
        private byte[] statesByteArray;
        private Throwable throwable;
        private byte[] throwableByteArray;

        private Builder() {
        }

        @Override
        public JobStatesResponseBuilder states(Collection<JobState> states) {
            this.states = states;
            return this;
        }

        @Override
        public JobStatesResponseBuilder statesByteArray(byte[] statesByteArray) {
            this.statesByteArray = statesByteArray;
            return this;
        }

        @Override
        public JobStatesResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public JobStatesResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public Collection<JobState> states() {
            return this.states;
        }

        @Override
        public byte[] statesByteArray() {
            return this.statesByteArray;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public JobStatesResponse build() {
            return new JobStatesResponseImpl(this.states, this.statesByteArray, this.throwable, this.throwableByteArray);
        }
    }
}

