/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractZoneCommand;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.RenameZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.storage.AlterZoneEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;

public class RenameZoneCommand
extends AbstractZoneCommand {
    private final boolean ifExists;
    private final String newZoneName;

    public static RenameZoneCommandBuilder builder() {
        return new Builder();
    }

    private RenameZoneCommand(String zoneName, boolean ifExists, String newZoneName) throws CatalogValidationException {
        super(zoneName);
        this.ifExists = ifExists;
        this.newZoneName = newZoneName;
        this.validate();
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogZoneDescriptor zone = CatalogUtils.zone(catalog, this.zoneName, !this.ifExists);
        if (zone == null) {
            return List.of();
        }
        if (catalog.zone(this.newZoneName) != null) {
            throw new CatalogValidationException("Distribution zone with name '{}' already exists.", this.newZoneName);
        }
        CatalogZoneDescriptor descriptor = new CatalogZoneDescriptor(zone.id(), this.newZoneName, zone.partitions(), zone.replicas(), zone.quorumSize(), zone.dataNodesAutoAdjustScaleUp(), zone.dataNodesAutoAdjustScaleDown(), zone.filter(), zone.storageProfiles(), zone.consistencyMode());
        return List.of(new AlterZoneEntry(descriptor));
    }

    private void validate() {
        CatalogParamsValidationUtils.validateIdentifier(this.newZoneName, "New zone name");
    }

    private static class Builder
    implements RenameZoneCommandBuilder {
        private String zoneName;
        private boolean ifExists;
        private String newZoneName;

        private Builder() {
        }

        @Override
        public RenameZoneCommandBuilder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public RenameZoneCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public RenameZoneCommandBuilder newZoneName(String newZoneName) {
            this.newZoneName = newZoneName;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new RenameZoneCommand(this.zoneName, this.ifExists, this.newZoneName);
        }
    }
}

