/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.config.ini;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite3.internal.cli.config.exception.ConfigStoringException;
import org.apache.ignite3.internal.cli.config.ini.IniParser;
import org.apache.ignite3.internal.cli.config.ini.IniSection;
import org.apache.ignite3.internal.cli.config.ini.SectionAlreadyExistsException;

public class IniFile {
    private final Map<String, IniSection> content;
    private final IniSection topLevelSection;
    private final File file;

    public IniFile(File file) throws IOException {
        this.content = new IniParser().parse(file);
        this.topLevelSection = this.content.remove("NO_SECTION");
        this.file = file;
    }

    public synchronized IniSection getSection(String name) {
        return this.content.get(name);
    }

    public IniSection getTopLevelSection() {
        return this.topLevelSection;
    }

    public synchronized Collection<String> getSectionNames() {
        return this.content.keySet();
    }

    public synchronized Collection<IniSection> getSections() {
        return this.content.values();
    }

    public void store() {
        try (OutputStream os = Files.newOutputStream(this.file.toPath(), new OpenOption[0]);){
            this.store(os);
        }
        catch (IOException e) {
            throw new ConfigStoringException("Can't store cli config file " + this.file.getAbsolutePath(), e);
        }
    }

    private void store(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        IniSection topLevelSection = this.getTopLevelSection();
        if (topLevelSection != null) {
            this.writeSection(bufferedWriter, topLevelSection);
        }
        for (IniSection section : this.getSections()) {
            if (section == topLevelSection) continue;
            bufferedWriter.write("[" + section.getName() + "]");
            bufferedWriter.newLine();
            this.writeSection(bufferedWriter, section);
        }
        bufferedWriter.flush();
    }

    private void writeSection(BufferedWriter bufferedWriter, IniSection section) throws IOException {
        for (Map.Entry<String, String> sectionEntry : section.getAll().entrySet()) {
            bufferedWriter.write(sectionEntry.getKey() + " = ");
            bufferedWriter.write(sectionEntry.getValue());
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
    }

    public synchronized IniSection createSection(String name) {
        if (this.content.containsKey(name)) {
            throw new SectionAlreadyExistsException(name);
        }
        IniSection iniSection = new IniSection(name);
        this.content.put(name, iniSection);
        return iniSection;
    }

    public synchronized IniSection getOrCreateSection(String name) {
        return this.content.computeIfAbsent(name, IniSection::new);
    }
}

