/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.fileio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.ignite3.internal.fileio.AbstractFileIo;
import org.apache.ignite3.internal.util.IgniteUtils;

public class AsyncFileIo
extends AbstractFileIo {
    private final AsynchronousFileChannel ch;
    private volatile long position;
    private final Set<ChannelOpFuture> asyncFutures = ConcurrentHashMap.newKeySet();

    public AsyncFileIo(Path filePath, OpenOption ... modes) throws IOException {
        this.ch = AsynchronousFileChannel.open(filePath, modes);
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public void position(long newPosition) {
        this.position = newPosition;
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        ChannelOpFuture future = new ChannelOpFuture();
        this.ch.read(destBuf, this.position, this, future);
        return future.waitUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer destBuf, long position) throws IOException {
        ChannelOpFuture future = new ChannelOpFuture();
        this.ch.read(destBuf, position, null, future);
        try {
            int n = future.waitUninterruptibly();
            return n;
        }
        finally {
            this.asyncFutures.remove(future);
        }
    }

    @Override
    public int read(byte[] buf, int off, int length) throws IOException {
        ChannelOpFuture future = new ChannelOpFuture();
        this.ch.read(ByteBuffer.wrap(buf, off, length), this.position, this, future);
        return future.waitUninterruptibly();
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        ChannelOpFuture future = new ChannelOpFuture();
        this.ch.write(srcBuf, this.position, this, future);
        return future.waitUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer srcBuf, long position) throws IOException {
        ChannelOpFuture future = new ChannelOpFuture();
        this.asyncFutures.add(future);
        this.ch.write(srcBuf, position, null, future);
        try {
            int n = future.waitUninterruptibly();
            return n;
        }
        finally {
            this.asyncFutures.remove(future);
        }
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        ChannelOpFuture future = new ChannelOpFuture();
        this.ch.write(ByteBuffer.wrap(buf, off, len), this.position, this, future);
        return future.waitUninterruptibly();
    }

    @Override
    public MappedByteBuffer map(int sizeBytes) {
        throw new UnsupportedOperationException("AsynchronousFileChannel doesn't support mmap.");
    }

    @Override
    public void force() throws IOException {
        this.force(false);
    }

    @Override
    public void force(boolean withMetadata) throws IOException {
        this.ch.force(withMetadata);
    }

    @Override
    public long size() throws IOException {
        return this.ch.size();
    }

    @Override
    public void clear() throws IOException {
        this.ch.truncate(0L);
        this.position = 0L;
    }

    @Override
    public void close() throws IOException {
        for (ChannelOpFuture future : this.asyncFutures) {
            future.waitUninterruptibly();
        }
        this.ch.close();
    }

    static class ChannelOpFuture
    extends CompletableFuture<Integer>
    implements CompletionHandler<Integer, AsyncFileIo> {
        ChannelOpFuture() {
        }

        @Override
        public void completed(Integer res, AsyncFileIo attach) {
            if (attach != null && res != -1) {
                attach.position += (long)res.intValue();
            }
            super.complete(res);
        }

        @Override
        public void failed(Throwable exc, AsyncFileIo attach) {
            super.completeExceptionally(exc);
        }

        int waitUninterruptibly() throws IOException {
            try {
                return IgniteUtils.getUninterruptibly(this);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IOException(cause);
            }
            catch (CancellationException e) {
                throw new IOException(e);
            }
        }
    }
}

