/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.metrics;

import java.util.List;
import org.apache.ignite3.internal.metastorage.metrics.MetaStorageMetrics;
import org.apache.ignite3.internal.metrics.AbstractMetricSource;
import org.apache.ignite3.internal.metrics.AtomicIntMetric;
import org.apache.ignite3.internal.metrics.LongGauge;
import org.apache.ignite3.internal.metrics.LongMetric;
import org.apache.ignite3.internal.metrics.Metric;

public class MetaStorageMetricSource
extends AbstractMetricSource<Holder> {
    private static final String SOURCE_NAME = "metastorage";
    private final MetaStorageMetrics metaStorageMetrics;

    public MetaStorageMetricSource(MetaStorageMetrics metaStorageMetrics) {
        super(SOURCE_NAME);
        this.metaStorageMetrics = metaStorageMetrics;
    }

    @Override
    protected Holder createHolder() {
        return new Holder();
    }

    public void onIdempotentCacheSizeChange(int newSize) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.idempotentCacheSize.value(newSize);
        }
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final LongMetric safeTimeLag = new LongGauge("SafeTimeLag", "Number of milliseconds the local MetaStorage SafeTime lags behind the local logical clock.", MetaStorageMetricSource.this.metaStorageMetrics::safeTimeLag);
        private final AtomicIntMetric idempotentCacheSize = new AtomicIntMetric("IdempotentCacheSize", "The current size of the cache of idempotent commands' results.");
        private final List<Metric> metrics = List.of(this.safeTimeLag, this.idempotentCacheSize);

        protected Holder() {
        }

        @Override
        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

