/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.server;

import java.util.Arrays;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.server.AbstractSimpleCondition;

public class ValueCondition
extends AbstractSimpleCondition {
    private final Type type;
    private final byte[] val;

    public ValueCondition(Type type, byte[] key, byte[] val) {
        super(key);
        this.type = type;
        this.val = val;
    }

    @Override
    public boolean test(Entry e) {
        int res = Arrays.compare(e.value(), this.val);
        return this.type.test(res);
    }

    public static enum Type {
        EQUAL{

            @Override
            public boolean test(long res) {
                return res == 0L;
            }
        }
        ,
        NOT_EQUAL{

            @Override
            public boolean test(long res) {
                return res != 0L;
            }
        }
        ,
        GREATER{

            @Override
            public boolean test(long res) {
                return res > 0L;
            }
        }
        ,
        LESS{

            @Override
            public boolean test(long res) {
                return res < 0L;
            }
        }
        ,
        LESS_OR_EQUAL{

            @Override
            public boolean test(long res) {
                return res <= 0L;
            }
        }
        ,
        GREATER_OR_EQUAL{

            @Override
            public boolean test(long res) {
                return res >= 0L;
            }
        };


        public abstract boolean test(long var1);
    }
}

