/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metrics;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.DoubleFunction;
import org.apache.ignite3.internal.metrics.AbstractMetric;
import org.apache.ignite3.internal.metrics.DoubleMetric;
import org.jetbrains.annotations.Nullable;

public class SimpleMovingAverage
extends AbstractMetric
implements DoubleMetric {
    public static final int DFLT_ITEMS = 100;
    private final int items;
    ConcurrentLinkedDeque<Double> queue = new ConcurrentLinkedDeque();

    public SimpleMovingAverage(String name, @Nullable String desc, @Nullable DoubleFunction<String> stringFormatter) {
        this(name, desc, stringFormatter, 100);
    }

    public SimpleMovingAverage(String name, @Nullable String desc, DoubleFunction<String> stringFormatter, int items) {
        super(name, desc);
        this.items = items;
    }

    public void add(double val) {
        this.queue.add(val);
        while (this.queue.size() > this.items) {
            this.queue.pop();
        }
    }

    @Override
    public double value() {
        return this.queue.stream().mapToDouble(a -> a).average().orElse(0.0);
    }
}

