/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.disaster;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStatesRequest;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStatesRequestImpl;

class LocalPartitionStatesRequestSerializer
implements MessageSerializer<LocalPartitionStatesRequest> {
    public static final LocalPartitionStatesRequestSerializer INSTANCE = new LocalPartitionStatesRequestSerializer();

    private LocalPartitionStatesRequestSerializer() {
    }

    @Override
    public boolean writeMessage(LocalPartitionStatesRequest msg, MessageWriter writer) throws MessageMappingException {
        LocalPartitionStatesRequestImpl message = (LocalPartitionStatesRequestImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("catalogVersion", message.catalogVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeSet("partitionIds", message.partitionIds(), MessageCollectionItemType.INT);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeSet("zoneIds", message.zoneIds(), MessageCollectionItemType.INT);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

