/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partitiondistribution;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.partitiondistribution.Assignment;
import org.apache.ignite3.internal.partitiondistribution.Assignments;
import org.apache.ignite3.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.IgniteUtils;

public class PendingAssignmentsCalculator {
    private Assignments stable;
    private Assignments target;

    private PendingAssignmentsCalculator() {
    }

    public static PendingAssignmentsCalculator pendingAssignmentsCalculator() {
        return new PendingAssignmentsCalculator();
    }

    public PendingAssignmentsCalculator stable(Assignments stable) {
        this.stable = stable;
        return this;
    }

    public PendingAssignmentsCalculator target(Assignments target) {
        this.target = target;
        return this;
    }

    public AssignmentsQueue toQueue() {
        AssignmentsQueue queue;
        assert (this.stable != null);
        assert (this.target != null);
        if (this.target.force() || this.target.fromReset()) {
            return new AssignmentsQueue(this.target);
        }
        int size = this.target.nodes().size();
        HashSet<Assignment> base = IgniteUtils.newHashSet(size);
        HashSet<Assignment> promoted = IgniteUtils.newHashSet(size);
        HashSet<Assignment> demoted = IgniteUtils.newHashSet(size);
        HashSet<Assignment> demotedPeers = IgniteUtils.newHashSet(size);
        for (Assignment t : this.target.nodes()) {
            boolean found = false;
            for (Assignment s : this.stable.nodes()) {
                if (s.equals(t)) {
                    found = true;
                    base.add(t);
                    continue;
                }
                if (!t.consistentId().equals(s.consistentId())) continue;
                found = true;
                if (!s.isPeer() && t.isPeer()) {
                    promoted.add(t);
                }
                if (!s.isPeer() || t.isPeer()) continue;
                demoted.add(t);
                demotedPeers.add(s);
            }
            if (found) continue;
            base.add(t);
        }
        if (promoted.isEmpty() && demoted.isEmpty()) {
            queue = new AssignmentsQueue(Assignments.of(base, this.target.timestamp()));
        } else if (promoted.isEmpty() || demoted.isEmpty()) {
            Set<Assignment> withPromotedOrDemoted = CollectionUtils.union(base, promoted.isEmpty() ? demoted : promoted);
            queue = new AssignmentsQueue(Assignments.of(base, this.target.timestamp()), Assignments.of(withPromotedOrDemoted, this.target.timestamp()));
        } else {
            Set<Assignment> withOldPeers = CollectionUtils.union(base, demotedPeers);
            Set<Assignment> withPromoted = CollectionUtils.union(base, promoted);
            Set<Assignment> withDemotedPeers = CollectionUtils.union(withPromoted, demoted);
            queue = new AssignmentsQueue(Assignments.of(withOldPeers, this.target.timestamp()), Assignments.of(withPromoted, this.target.timestamp()), Assignments.of(withDemotedPeers, this.target.timestamp()));
        }
        assert (Objects.equals(queue.peekLast().nodes(), this.target.nodes())) : "Target assignments should be equal to the last element in the queue";
        return queue;
    }
}

