/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.configuration.SuperRootChange;
import org.apache.ignite3.configuration.annotation.ConfigurationType;
import org.apache.ignite3.internal.replicator.configuration.ReplicationExtensionChange;
import org.apache.ignite3.internal.replicator.configuration.ReplicationExtensionConfiguration;
import org.apache.ignite3.internal.replicator.configuration.ReplicationExtensionConfigurationSchema;
import org.apache.ignite3.internal.replicator.configuration.ReplicationExtensionView;
import org.apache.ignite3.internal.replicator.configuration.StorageUpdateView;

@AutoService(value={ConfigurationModule.class})
public class ReplicationConfigurationModule
implements ConfigurationModule {
    @Override
    public ConfigurationType type() {
        return ConfigurationType.DISTRIBUTED;
    }

    @Override
    public Collection<Class<?>> schemaExtensions() {
        return List.of(ReplicationExtensionConfigurationSchema.class);
    }

    @Override
    public void migrateDeprecatedConfigurations(SuperRootChange superRootChange) {
        ReplicationExtensionView rootView = superRootChange.viewRoot(ReplicationExtensionConfiguration.KEY);
        ReplicationExtensionChange rootChange = superRootChange.changeRoot(ReplicationExtensionConfiguration.KEY);
        StorageUpdateView storageUpdateView = rootView.storageUpdate();
        if (storageUpdateView.batchByteLength() != 8192) {
            rootChange.changeReplication().changeBatchSizeBytes(storageUpdateView.batchByteLength());
        }
    }
}

