/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.deployunit.CachedDeploymentUnit;
import org.apache.ignite3.internal.deployunit.DeploymentUnit;
import org.apache.ignite3.internal.deployunit.FilesDeploymentUnit;
import org.apache.ignite3.internal.deployunit.tempstorage.TempStorage;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.rest.deployment.InputStreamCollector;

public class InputStreamCollectorImpl
implements InputStreamCollector {
    private static final IgniteLogger LOG = Loggers.forClass(InputStreamCollectorImpl.class);
    private final Map<String, CompletableFuture<Path>> collect = new HashMap<String, CompletableFuture<Path>>();
    private final TempStorage tempStorage;

    public InputStreamCollectorImpl(TempStorage tempStorage) {
        this.tempStorage = tempStorage;
    }

    @Override
    public void addInputStream(String filename, InputStream is) {
        this.collect.put(filename, (CompletableFuture<Path>)this.tempStorage.store(filename, is).whenComplete((path, throwable) -> {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error("Error when closing input stream.", (Throwable)e);
            }
        }));
    }

    @Override
    public DeploymentUnit toDeploymentUnit() {
        ConcurrentHashMap map = new ConcurrentHashMap();
        for (Map.Entry<String, CompletableFuture<Path>> e : this.collect.entrySet()) {
            e.getValue().thenAccept(path -> map.put((String)e.getKey(), path));
        }
        return new CachedDeploymentUnit((CompletableFuture<DeploymentUnit>)CompletableFuture.allOf(this.collect.values().toArray(new CompletableFuture[0])).thenApply(unused -> new FilesDeploymentUnit(map)));
    }

    @Override
    public void rollback() throws Exception {
        this.tempStorage.rollback();
    }
}

