/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema;

import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.schema.row.RowAssembler;

public class BinaryRowUpgrader {
    private final SchemaRegistry schemaRegistry;
    private final SchemaDescriptor targetSchema;

    public BinaryRowUpgrader(SchemaRegistry schemaRegistry, int targetSchemaVersion) {
        this(schemaRegistry, schemaRegistry.schema(targetSchemaVersion));
    }

    public BinaryRowUpgrader(SchemaRegistry schemaRegistry, SchemaDescriptor targetSchema) {
        this.schemaRegistry = schemaRegistry;
        this.targetSchema = targetSchema;
    }

    public BinaryRow upgrade(BinaryRow source) {
        if (source.schemaVersion() >= this.targetSchema.version()) {
            return source;
        }
        Row upgradedRow = this.schemaRegistry.resolve(source, this.targetSchema);
        RowAssembler rowAssembler = new RowAssembler(this.targetSchema, -1);
        for (int i = 0; i < this.targetSchema.length(); ++i) {
            rowAssembler.appendValue(upgradedRow.value(i));
        }
        return new BinaryRowImpl(this.targetSchema.version(), rowAssembler.build().tupleSlice());
    }
}

