/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.CorrelatesBuilder;
import org.apache.ignite3.internal.sql.engine.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite3.internal.sql.engine.exec.exp.FieldGetter;
import org.apache.ignite3.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlProjection;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.IgniteMethod;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.sql.engine.util.cache.Cache;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;

class ProjectionImplementor {
    private final Cache<String, Object> cache;
    private final RexBuilder rexBuilder;
    private final JavaTypeFactory typeFactory;
    private final SqlConformance conformance;

    ProjectionImplementor(Cache<String, Object> cache, RexBuilder rexBuilder, JavaTypeFactory typeFactory, SqlConformance conformance) {
        this.cache = cache;
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
    }

    public <RowT> SqlProjection<RowT> implement(List<RexNode> projections, RelDataType type) {
        String digest = ExpressionFactoryImpl.digest(SqlProjection.class, projections, type);
        Cache cache = (Cache)Commons.cast(this.cache);
        return cache.get(digest, key -> {
            RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RexUtil.types((List)projections));
            SqlProjectionExt projectionExt = this.implementInternal(projections, type);
            return new SqlProjectionImpl(projectionExt, rowSchema);
        });
    }

    private <RowT> SqlProjectionExt<RowT> implementInternal(List<RexNode> projections, RelDataType type) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(type, this.rexBuilder);
        for (RexNode node : projections) {
            assert (node != null) : "unexpected nullable node";
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression ctx = Expressions.parameter(ExecutionContext.class, (String)"ctx");
        ParameterExpression row = Expressions.parameter(Object.class, (String)"row");
        ParameterExpression outBuilder = Expressions.parameter(RowHandler.RowBuilder.class, (String)"outBuilder");
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)DataContext.ROOT, (Expression)Expressions.convert_((Expression)ctx, DataContext.class)));
        Expression rowHandler = builder.append("hnd", (Expression)Expressions.call((Expression)ctx, (Method)IgniteMethod.CONTEXT_ROW_HANDLER.method(), (Expression[])new Expression[0]));
        FieldGetter inputGetter = new FieldGetter(rowHandler, (Expression)row, type);
        Function1<String, RexToLixTranslator.InputGetter> correlates = new CorrelatesBuilder(builder, (Expression)ctx, rowHandler).build(projections);
        List<Expression> projects = RexToLixTranslator.translateProjects(program, this.typeFactory, this.conformance, builder, null, null, (Expression)ctx, inputGetter, correlates);
        for (Expression val : projects) {
            MethodCallExpression addRowField = Expressions.call((Expression)outBuilder, (Method)IgniteMethod.ROW_BUILDER_ADD_FIELD.method(), (Expression[])new Expression[]{val});
            builder.add(Expressions.statement((Expression)addRowField));
        }
        ParameterExpression ex = Expressions.parameter((int)0, Exception.class, (String)"e");
        NewExpression sqlException = Expressions.new_(SqlException.class, (Expression[])new Expression[]{Expressions.constant((Object)ErrorGroups.Sql.RUNTIME_ERR), ex});
        BlockBuilder tryCatchBlock = new BlockBuilder();
        tryCatchBlock.add((Statement)Expressions.tryCatch((Statement)builder.toBlock(), (CatchBlock[])new CatchBlock[]{Expressions.catch_((ParameterExpression)ex, (Statement)Expressions.throw_((Expression)sqlException))}));
        List<ParameterExpression> params = List.of(ctx, row, outBuilder);
        MethodDeclaration declaration = Expressions.methodDecl((int)1, Void.TYPE, (String)"project", params, (BlockStatement)tryCatchBlock.toBlock());
        Class clazz = (Class)Commons.cast(SqlProjectionExt.class);
        String body = Expressions.toString(List.of(declaration), (String)"\n", (boolean)false);
        return (SqlProjectionExt)Commons.compile(clazz, body);
    }

    @FunctionalInterface
    public static interface SqlProjectionExt<RowT> {
        public void project(ExecutionContext<RowT> var1, RowT var2, RowHandler.RowBuilder<RowT> var3);
    }

    private static class SqlProjectionImpl<RowT>
    implements SqlProjection<RowT> {
        private final SqlProjectionExt<RowT> projection;
        private final RowSchema rowSchema;

        private SqlProjectionImpl(SqlProjectionExt<RowT> projection, RowSchema rowSchema) {
            this.projection = projection;
            this.rowSchema = rowSchema;
        }

        private RowHandler.RowBuilder<RowT> builder(ExecutionContext<RowT> context) {
            return context.rowHandler().factory(this.rowSchema).rowBuilder();
        }

        @Override
        public RowT project(ExecutionContext<RowT> context, RowT row) {
            RowHandler.RowBuilder<RowT> rowBuilder = this.builder(context);
            this.projection.project(context, row, rowBuilder);
            return rowBuilder.buildAndReset();
        }
    }
}

