/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare;

import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.AliasNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;

public class IgniteAliasNamespace
extends AliasNamespace {
    IgniteAliasNamespace(SqlValidatorImpl validator, SqlCall call, SqlNode enclosingNode) {
        super(validator, call, enclosingNode);
    }

    protected RelDataType validateImpl(RelDataType targetRowType) {
        List operands = this.call.getOperandList();
        if (operands.size() == 2) {
            return super.validateImpl(targetRowType);
        }
        SqlValidatorNamespace childNs = this.validator.getNamespace((SqlNode)operands.get(0));
        assert (childNs != null) : "Alias in FROM list must have a namespace";
        SqlValidatorTable table = childNs.getTable();
        if (table == null) {
            return super.validateImpl(targetRowType);
        }
        List columnNames = Util.skip((List)operands, (int)2);
        List nameList = SqlIdentifier.simpleNames((List)columnNames);
        int i = Util.firstDuplicate((List)nameList);
        if (i >= 0) {
            SqlIdentifier id = (SqlIdentifier)columnNames.get(i);
            throw this.validator.newValidationError((SqlNode)id, Static.RESOURCE.aliasListDuplicate(id.getSimple()));
        }
        TableDescriptor descriptor = (TableDescriptor)table.unwrap(TableDescriptor.class);
        assert (descriptor != null);
        RelDataType rowTypeSansHidden = descriptor.rowTypeSansHidden();
        if (columnNames.size() != rowTypeSansHidden.getFieldList().size()) {
            SqlNodeList node = operands.size() == 3 ? (SqlNode)operands.get(2) : new SqlNodeList((Collection)columnNames, SqlParserPos.sum((List)columnNames));
            throw this.validator.newValidationError((SqlNode)node, Static.RESOURCE.aliasListDegree(rowTypeSansHidden.getFieldCount(), IgniteAliasNamespace.getString(rowTypeSansHidden), columnNames.size()));
        }
        RelDataType rowType = childNs.getRowTypeSansSystemColumns();
        assert (rowType != null);
        int fieldsCount = rowType.getFieldCount();
        Mapping mapping = Mappings.create((MappingType)MappingType.PARTIAL_FUNCTION, (int)fieldsCount, (int)nameList.size());
        int idx = 0;
        for (ColumnDescriptor column : descriptor) {
            if (column.hidden()) continue;
            mapping.set(column.logicalIndex(), idx++);
        }
        RelDataType aliasedType = this.validator.getTypeFactory().builder().addAll((Iterable)Util.transform((List)rowType.getFieldList(), f -> {
            int index = mapping.getTargetOpt(f.getIndex());
            String name = index == -1 ? f.getName() : (String)nameList.get(index);
            return Pair.of((Object)name, (Object)f.getType());
        })).kind(rowType.getStructKind()).build();
        return this.validator.getTypeFactory().createTypeWithNullability(aliasedType, rowType.isNullable());
    }

    private static String getString(RelDataType rowType) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (RelDataTypeField field : rowType.getFieldList()) {
            if (field.getIndex() > 0) {
                buf.append(", ");
            }
            buf.append('\'').append(field.getName()).append('\'');
        }
        buf.append(')');
        return buf.toString();
    }
}

