/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.criteria;

import java.util.Collection;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.table.criteria.Column;
import org.apache.ignite3.table.criteria.Criteria;
import org.apache.ignite3.table.criteria.CriteriaVisitor;
import org.apache.ignite3.table.criteria.Expression;
import org.apache.ignite3.table.criteria.Parameter;
import org.jetbrains.annotations.Nullable;

class ColumnValidator
implements CriteriaVisitor<Collection<String>> {
    static final ColumnValidator INSTANCE = new ColumnValidator();

    ColumnValidator() {
    }

    @Override
    public <T> void visit(Parameter<T> argument, @Nullable Collection<String> context) {
    }

    @Override
    public <T> void visit(Column column, @Nullable Collection<String> context) {
        String colName = column.getName();
        if (!CollectionUtils.nullOrEmpty(context) && !context.contains(colName)) {
            throw new IllegalArgumentException("Unexpected column name: " + colName);
        }
    }

    @Override
    public <T> void visit(Expression expression, @Nullable Collection<String> context) {
        for (Criteria element : expression.getElements()) {
            element.accept(this, context);
        }
    }

    @Override
    public <T> void visit(Criteria criteria, @Nullable Collection<String> context) {
        criteria.accept(this, context);
    }
}

