/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.disaster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryRequest;
import org.apache.ignite3.internal.table.distributed.disaster.GroupUpdateRequest;
import org.apache.ignite3.internal.table.distributed.disaster.GroupUpdateRequestSerializer;
import org.apache.ignite3.internal.table.distributed.disaster.ManualGroupRestartRequest;
import org.apache.ignite3.internal.table.distributed.disaster.ManualGroupRestartRequestSerializer;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

class DisasterRecoveryRequestSerializer
extends VersionedSerializer<DisasterRecoveryRequest> {
    static final DisasterRecoveryRequestSerializer INSTANCE = new DisasterRecoveryRequestSerializer();

    DisasterRecoveryRequestSerializer() {
    }

    @Override
    protected void writeExternalData(DisasterRecoveryRequest request, IgniteDataOutput out) throws IOException {
        Operation operation = Operation.findByRequest(request);
        out.writeVarInt(operation.code);
        operation.serialize(request, out);
    }

    @Override
    protected DisasterRecoveryRequest readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        int operationCode = in.readVarIntAsInt();
        Operation operation = Operation.findByCode(operationCode);
        return operation.deserialize(in);
    }

    private static enum Operation {
        GROUP_UPDATE(0, GroupUpdateRequestSerializer.INSTANCE),
        MANUAL_GROUP_RESTART(1, ManualGroupRestartRequestSerializer.INSTANCE);

        private static final Map<Integer, Operation> valuesByCode;
        private final int code;
        private final VersionedSerializer<DisasterRecoveryRequest> serializer;

        private Operation(int code, VersionedSerializer<? extends DisasterRecoveryRequest> serializer) {
            this.code = code;
            this.serializer = serializer;
        }

        static Operation findByCode(int code) {
            Operation operation = valuesByCode.get(code);
            if (operation == null) {
                throw new IllegalArgumentException("Unknown operation code: " + code);
            }
            return operation;
        }

        static Operation findByRequest(DisasterRecoveryRequest request) {
            if (request instanceof GroupUpdateRequest) {
                return GROUP_UPDATE;
            }
            if (request instanceof ManualGroupRestartRequest) {
                return MANUAL_GROUP_RESTART;
            }
            throw new IllegalArgumentException("Unknown request type: " + request);
        }

        void serialize(DisasterRecoveryRequest request, IgniteDataOutput out) throws IOException {
            this.serializer.writeExternal(request, out);
        }

        <T extends DisasterRecoveryRequest> T deserialize(IgniteDataInput in) throws IOException {
            return (T)this.serializer.readExternal(in);
        }

        static {
            valuesByCode = Arrays.stream(Operation.values()).collect(Collectors.toUnmodifiableMap(op -> op.code, Function.identity()));
        }
    }
}

