/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.placementdriver.ReplicaMeta;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.tx.MismatchingTransactionOutcomeInternalException;
import org.apache.ignite3.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite3.internal.tx.TransactionResult;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.impl.PrimaryReplicaExpiredException;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TransactionInflights {
    private static final int MAX_CONCURRENT_TXNS = 1024;
    private final ConcurrentHashMap<UUID, TxContext> txCtxMap = new ConcurrentHashMap(1024);
    private final PlacementDriver placementDriver;
    private final ClockService clockService;

    public TransactionInflights(PlacementDriver placementDriver, ClockService clockService) {
        this.placementDriver = placementDriver;
        this.clockService = clockService;
    }

    public boolean addInflight(UUID txId) {
        boolean[] res = new boolean[]{true};
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = new ReadWriteTxContext(this.placementDriver, this.clockService);
            }
            res[0] = ctx.addInflight();
            return ctx;
        });
        return res[0];
    }

    public boolean addScanInflight(UUID txId) {
        boolean[] res = new boolean[]{true};
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = new ReadOnlyTxContext();
            }
            res[0] = ctx.addInflight();
            return ctx;
        });
        return res[0];
    }

    public boolean track(UUID txId) {
        boolean[] res = new boolean[]{true};
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = new ReadWriteTxContext(this.placementDriver, this.clockService);
            }
            res[0] = !ctx.isTxFinishing();
            return ctx;
        });
        return res[0];
    }

    public boolean trackReadOnly(UUID txId) {
        boolean[] res = new boolean[]{true};
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = new ReadOnlyTxContext();
            }
            res[0] = !ctx.isTxFinishing();
            return ctx;
        });
        return res[0];
    }

    public void removeInflight(UUID txId) {
        TxContext tuple = this.txCtxMap.computeIfPresent(txId, (uuid, ctx) -> {
            ctx.removeInflight(txId);
            return ctx;
        });
        if (tuple != null) {
            tuple.onInflightsRemoved();
        }
    }

    @TestOnly
    public boolean hasActiveInflights() {
        for (TxContext value : this.txCtxMap.values()) {
            if (value.isTxFinishing()) continue;
            return true;
        }
        return false;
    }

    Collection<UUID> finishedReadOnlyTransactions() {
        return this.txCtxMap.entrySet().stream().filter(e -> e.getValue() instanceof ReadOnlyTxContext && ((TxContext)e.getValue()).isReadyToFinish()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    void removeTxContext(UUID txId) {
        this.txCtxMap.remove(txId);
    }

    void removeTxContexts(Collection<UUID> txIds) {
        ((ConcurrentHashMap.KeySetView)this.txCtxMap.keySet()).removeAll((Collection)txIds);
    }

    void cancelWaitingInflights(ReplicationGroupId groupId) {
        for (Map.Entry<UUID, TxContext> ctxEntry : this.txCtxMap.entrySet()) {
            PendingTxPartitionEnlistment enlistment;
            ReadWriteTxContext txContext;
            if (!(ctxEntry.getValue() instanceof ReadWriteTxContext) || !(txContext = (ReadWriteTxContext)ctxEntry.getValue()).isTxFinishing() || (enlistment = txContext.enlistedGroups.get(groupId)) == null) continue;
            txContext.cancelWaitingInflights(groupId, enlistment.consistencyToken());
        }
    }

    void markReadOnlyTxFinished(UUID txId) {
        this.txCtxMap.compute(txId, (k, ctx) -> {
            if (ctx == null) {
                ctx = new ReadOnlyTxContext();
            } else assert (ctx instanceof ReadOnlyTxContext);
            ctx.finishTx(null);
            return ctx;
        });
    }

    ReadWriteTxContext lockTxForNewUpdates(UUID txId, Map<ReplicationGroupId, PendingTxPartitionEnlistment> enlistedGroups) {
        return (ReadWriteTxContext)this.txCtxMap.compute(txId, (uuid, tuple0) -> {
            if (tuple0 == null) {
                tuple0 = new ReadWriteTxContext(this.placementDriver, this.clockService, true);
            }
            assert (!tuple0.isTxFinishing()) : "Transaction is already finished [id=" + uuid + "].";
            tuple0.finishTx(enlistedGroups);
            return tuple0;
        });
    }

    static abstract class TxContext {
        volatile long inflights = 0L;

        TxContext() {
        }

        boolean addInflight() {
            if (this.isTxFinishing()) {
                return false;
            }
            ++this.inflights;
            return true;
        }

        void removeInflight(UUID txId) {
            assert (this.inflights > 0L) : IgniteStringFormatter.format("No inflights, cannot remove any [txId={}, ctx={}]", txId, this);
            --this.inflights;
        }

        abstract void onInflightsRemoved();

        abstract void finishTx(@Nullable Map<ReplicationGroupId, PendingTxPartitionEnlistment> var1);

        abstract boolean isTxFinishing();

        abstract boolean isReadyToFinish();
    }

    static class ReadWriteTxContext
    extends TxContext {
        private final CompletableFuture<Void> waitRepFut = new CompletableFuture();
        private final PlacementDriver placementDriver;
        private final boolean noWrites;
        private volatile CompletableFuture<Void> finishInProgressFuture = null;
        private volatile Map<ReplicationGroupId, PendingTxPartitionEnlistment> enlistedGroups;
        private final ClockService clockService;

        private ReadWriteTxContext(PlacementDriver placementDriver, ClockService clockService) {
            this(placementDriver, clockService, false);
        }

        private ReadWriteTxContext(PlacementDriver placementDriver, ClockService clockService, boolean noWrites) {
            this.placementDriver = placementDriver;
            this.clockService = clockService;
            this.noWrites = noWrites;
        }

        CompletableFuture<Void> performFinish(boolean commit, Function<Boolean, CompletableFuture<Void>> finishAction) {
            this.waitReadyToFinish(commit).whenComplete((ignoredReadyToFinish, readyException) -> {
                try {
                    CompletableFuture actionFut = (CompletableFuture)finishAction.apply(commit && readyException == null);
                    actionFut.whenComplete((ignoredFinishActionResult, finishException) -> this.completeFinishInProgressFuture(commit, (Throwable)readyException, (Throwable)finishException));
                }
                catch (Throwable err) {
                    this.completeFinishInProgressFuture(commit, (Throwable)readyException, err);
                }
            });
            return this.finishInProgressFuture;
        }

        private void completeFinishInProgressFuture(boolean commit, @Nullable Throwable readyToFinishException, @Nullable Throwable finishException) {
            if (readyToFinishException == null) {
                if (finishException == null) {
                    this.finishInProgressFuture.complete(null);
                } else {
                    this.finishInProgressFuture.completeExceptionally(finishException);
                }
            } else {
                Throwable unwrappedReadyToFinishException = ExceptionUtils.unwrapCause(readyToFinishException);
                if (commit && unwrappedReadyToFinishException instanceof PrimaryReplicaExpiredException) {
                    this.finishInProgressFuture.completeExceptionally(new MismatchingTransactionOutcomeInternalException(ErrorGroups.Transactions.TX_PRIMARY_REPLICA_EXPIRED_ERR, "Failed to commit the transaction.", new TransactionResult(TxState.ABORTED, null), unwrappedReadyToFinishException));
                } else {
                    this.finishInProgressFuture.completeExceptionally(unwrappedReadyToFinishException);
                }
            }
        }

        private CompletableFuture<Void> waitReadyToFinish(boolean commit) {
            if (commit) {
                HybridTimestamp now = this.clockService.now();
                CompletableFuture[] futures = new CompletableFuture[this.enlistedGroups.size()];
                int cntr = 0;
                for (Map.Entry<ReplicationGroupId, PendingTxPartitionEnlistment> e : this.enlistedGroups.entrySet()) {
                    futures[cntr++] = this.placementDriver.getPrimaryReplica(e.getKey(), now).thenApply(replicaMeta -> {
                        long enlistmentConsistencyToken = ((PendingTxPartitionEnlistment)e.getValue()).consistencyToken();
                        if (replicaMeta == null || enlistmentConsistencyToken != replicaMeta.getStartTime().longValue()) {
                            return CompletableFuture.failedFuture(new PrimaryReplicaExpiredException((ReplicationGroupId)e.getKey(), enlistmentConsistencyToken, null, (ReplicaMeta)replicaMeta));
                        }
                        return CompletableFutures.nullCompletedFuture();
                    });
                }
                return CompletableFutures.allOfToList(futures).thenCompose(unused -> this.waitNoInflights());
            }
            return CompletableFutures.nullCompletedFuture();
        }

        private CompletableFuture<Void> waitNoInflights() {
            if (this.inflights == 0L) {
                this.waitRepFut.complete(null);
            }
            return this.waitRepFut;
        }

        void cancelWaitingInflights(ReplicationGroupId groupId, long enlistmentConsistencyToken) {
            this.waitRepFut.completeExceptionally(new PrimaryReplicaExpiredException(groupId, enlistmentConsistencyToken, null, null));
        }

        @Override
        public void onInflightsRemoved() {
            if (this.inflights == 0L && this.finishInProgressFuture != null) {
                this.waitRepFut.complete(null);
            }
        }

        @Override
        public void finishTx(Map<ReplicationGroupId, PendingTxPartitionEnlistment> enlistedGroups) {
            this.enlistedGroups = enlistedGroups;
            this.finishInProgressFuture = new CompletableFuture();
        }

        @Override
        public boolean isTxFinishing() {
            return this.finishInProgressFuture != null;
        }

        @Override
        public boolean isReadyToFinish() {
            return this.waitRepFut.isDone();
        }

        boolean isNoWrites() {
            return this.noWrites;
        }

        public String toString() {
            return "ReadWriteTxContext [inflights=" + this.inflights + ", waitRepFut=" + this.waitRepFut + ", noWrites=" + this.noWrites + ", finishFut=" + this.finishInProgressFuture + "]";
        }
    }

    private static class ReadOnlyTxContext
    extends TxContext {
        private volatile boolean markedFinished;

        ReadOnlyTxContext() {
        }

        @Override
        public void onInflightsRemoved() {
        }

        @Override
        public void finishTx(@Nullable Map<ReplicationGroupId, PendingTxPartitionEnlistment> enlistedGroups) {
            this.markedFinished = true;
        }

        @Override
        public boolean isTxFinishing() {
            return this.markedFinished;
        }

        @Override
        public boolean isReadyToFinish() {
            return this.markedFinished && this.inflights == 0L;
        }

        public String toString() {
            return "ReadOnlyTxContext [inflights=" + this.inflights + "]";
        }
    }
}

