/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteDeploymentException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteComputeHandler;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.task.TaskExecutionOptions;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteComputeImpl
extends AsyncSupportAdapter<IgniteCompute>
implements IgniteCompute,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridKernalContext ctx;
    private ClusterGroupAdapter prj;
    private String execName;
    private IgniteComputeHandler compute;

    public IgniteComputeImpl() {
    }

    public IgniteComputeImpl(GridKernalContext ctx, ClusterGroupAdapter prj) {
        this(ctx, prj, false, null, null);
    }

    private IgniteComputeImpl(GridKernalContext ctx, ClusterGroupAdapter prj, boolean async, String execName, @Nullable IgniteComputeHandler compute) {
        super(async);
        this.ctx = ctx;
        this.prj = prj;
        this.execName = execName;
        this.compute = compute == null ? new IgniteComputeHandler(ctx, this::enrichOptions) : new IgniteComputeHandler(compute, this::enrichOptions);
    }

    @Override
    protected IgniteCompute createAsyncInstance() {
        return new IgniteComputeImpl(this.ctx, this.prj, true, this.execName, this.compute);
    }

    @Override
    public ClusterGroup clusterGroup() {
        return this.prj;
    }

    @Override
    public void affinityRun(String cacheName, Object affKey, IgniteRunnable job) {
        try {
            this.saveOrGet(this.compute.affinityRunAsync(cacheName, affKey, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> affinityRunAsync(String cacheName, Object affKey, IgniteRunnable job) throws IgniteException {
        return this.createFuture(this.compute.affinityRunAsync(cacheName, affKey, job));
    }

    @Override
    public void affinityRun(@NotNull Collection<String> cacheNames, Object affKey, IgniteRunnable job) {
        try {
            this.saveOrGet(this.compute.affinityRunAsync(cacheNames, affKey, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> affinityRunAsync(@NotNull Collection<String> cacheNames, Object affKey, IgniteRunnable job) throws IgniteException {
        return this.createFuture(this.compute.affinityRunAsync(cacheNames, affKey, job));
    }

    @Override
    public void affinityRun(@NotNull Collection<String> cacheNames, int partId, IgniteRunnable job) {
        try {
            this.saveOrGet(this.compute.affinityRunAsync(cacheNames, partId, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> affinityRunAsync(@NotNull Collection<String> cacheNames, int partId, IgniteRunnable job) throws IgniteException {
        return this.createFuture(this.compute.affinityRunAsync(cacheNames, partId, job));
    }

    @Override
    public <R> R affinityCall(String cacheName, Object affKey, IgniteCallable<R> job) {
        try {
            return this.saveOrGet(this.compute.affinityCallAsync(cacheName, affKey, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<R> affinityCallAsync(String cacheName, Object affKey, IgniteCallable<R> job) throws IgniteException {
        return this.createFuture(this.compute.affinityCallAsync(cacheName, affKey, job));
    }

    @Override
    public <R> R affinityCall(@NotNull Collection<String> cacheNames, Object affKey, IgniteCallable<R> job) {
        try {
            return this.saveOrGet(this.compute.affinityCallAsync(cacheNames, affKey, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<R> affinityCallAsync(@NotNull Collection<String> cacheNames, Object affKey, IgniteCallable<R> job) throws IgniteException {
        return this.createFuture(this.compute.affinityCallAsync(cacheNames, affKey, job));
    }

    @Override
    public <R> R affinityCall(@NotNull Collection<String> cacheNames, int partId, IgniteCallable<R> job) {
        try {
            return this.saveOrGet(this.compute.affinityCallAsync(cacheNames, partId, job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<R> affinityCallAsync(@NotNull Collection<String> cacheNames, int partId, IgniteCallable<R> job) throws IgniteException {
        return this.createFuture(this.compute.affinityCallAsync(cacheNames, partId, job));
    }

    @Override
    public <T, R> R execute(String taskName, @Nullable T arg) {
        try {
            return this.saveOrGet(this.compute.executeAsync(taskName, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> ComputeTaskFuture<R> executeAsync(String taskName, @Nullable T arg) throws IgniteException {
        return (ComputeTaskFuture)this.createFuture(this.compute.executeAsync(taskName, arg));
    }

    @Override
    public <T, R> R execute(Class<? extends ComputeTask<T, R>> taskCls, @Nullable T arg) {
        try {
            return this.saveOrGet(this.compute.withProjectionPredicate(this.prj.predicate()).executeAsync(taskCls, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> ComputeTaskFuture<R> executeAsync(Class<? extends ComputeTask<T, R>> taskCls, @Nullable T arg) throws IgniteException {
        return (ComputeTaskFuture)this.createFuture(this.compute.withProjectionPredicate(this.prj.predicate()).executeAsync(taskCls, arg));
    }

    @Override
    public <T, R> R execute(ComputeTask<T, R> task, @Nullable T arg) {
        try {
            return this.saveOrGet(this.compute.withProjectionPredicate(this.prj.predicate()).executeAsync(task, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> ComputeTaskFuture<R> executeAsync(ComputeTask<T, R> task, @Nullable T arg) throws IgniteException {
        return (ComputeTaskFuture)this.createFuture(this.compute.withProjectionPredicate(this.prj.predicate()).executeAsync(task, arg));
    }

    @Override
    public void broadcast(IgniteRunnable job) {
        try {
            this.saveOrGet(this.compute.broadcastAsync(job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> broadcastAsync(IgniteRunnable job) throws IgniteException {
        return this.createFuture(this.compute.broadcastAsync(job));
    }

    @Override
    public <R> Collection<R> broadcast(IgniteCallable<R> job) {
        try {
            return this.saveOrGet(this.compute.broadcastAsync(job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<Collection<R>> broadcastAsync(IgniteCallable<R> job) throws IgniteException {
        return this.createFuture(this.compute.broadcastAsync(job));
    }

    @Override
    public <R, T> Collection<R> broadcast(IgniteClosure<T, R> job, @Nullable T arg) {
        try {
            return this.saveOrGet(this.compute.broadcastAsync(job, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R, T> IgniteFuture<Collection<R>> broadcastAsync(IgniteClosure<T, R> job, @Nullable T arg) throws IgniteException {
        return this.createFuture(this.compute.broadcastAsync(job, arg));
    }

    @Override
    public void run(IgniteRunnable job) {
        try {
            this.saveOrGet(this.compute.runAsync(job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> runAsync(IgniteRunnable job) throws IgniteException {
        return this.createFuture(this.compute.runAsync(job));
    }

    @Override
    public void run(Collection<? extends IgniteRunnable> jobs) {
        try {
            this.saveOrGet(this.compute.runAsync(jobs));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> runAsync(Collection<? extends IgniteRunnable> jobs) throws IgniteException {
        return this.createFuture(this.compute.runAsync(jobs));
    }

    @Override
    public <R, T> R apply(IgniteClosure<T, R> job, @Nullable T arg) {
        try {
            return this.saveOrGet(this.compute.applyAsync(job, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R, T> IgniteFuture<R> applyAsync(IgniteClosure<T, R> job, @Nullable T arg) throws IgniteException {
        return this.createFuture(this.compute.applyAsync(job, arg));
    }

    @Override
    public <R> R call(IgniteCallable<R> job) {
        try {
            return this.saveOrGet(this.compute.callAsync(job));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<R> callAsync(IgniteCallable<R> job) throws IgniteException {
        return this.createFuture(this.compute.callAsync(job));
    }

    @Override
    public <R> Collection<R> call(Collection<? extends IgniteCallable<R>> jobs) {
        try {
            return this.saveOrGet(this.compute.callAsync(jobs));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> IgniteFuture<Collection<R>> callAsync(Collection<? extends IgniteCallable<R>> jobs) throws IgniteException {
        return this.createFuture(this.compute.callAsync(jobs));
    }

    @Override
    public <T, R> Collection<R> apply(IgniteClosure<T, R> job, @Nullable Collection<? extends T> args) {
        try {
            return this.saveOrGet(this.compute.applyAsync(job, args));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<Collection<R>> applyAsync(IgniteClosure<T, R> job, Collection<? extends T> args) throws IgniteException {
        return this.createFuture(this.compute.applyAsync(job, args));
    }

    @Override
    public <R1, R2> R2 call(Collection<? extends IgniteCallable<R1>> jobs, IgniteReducer<R1, R2> rdc) {
        try {
            return this.saveOrGet(this.compute.callAsync(jobs, rdc));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R1, R2> IgniteFuture<R2> callAsync(Collection<? extends IgniteCallable<R1>> jobs, IgniteReducer<R1, R2> rdc) throws IgniteException {
        return this.createFuture(this.compute.callAsync(jobs, rdc));
    }

    @Override
    public <R1, R2, T> R2 apply(IgniteClosure<T, R1> job, Collection<? extends T> args, IgniteReducer<R1, R2> rdc) {
        try {
            return this.saveOrGet(this.compute.applyAsync(job, args, rdc));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R1, R2, T> IgniteFuture<R2> applyAsync(IgniteClosure<T, R1> job, Collection<? extends T> args, IgniteReducer<R1, R2> rdc) throws IgniteException {
        return this.createFuture(this.compute.applyAsync(job, args, rdc));
    }

    @Override
    public <R> Map<IgniteUuid, ComputeTaskFuture<R>> activeTaskFutures() {
        this.guard();
        try {
            Map map = this.ctx.task().taskFutures();
            return map;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteCompute withName(String taskName) {
        this.compute.withName(taskName);
        return this;
    }

    @Override
    public IgniteCompute withTimeout(long timeout) {
        this.compute.withTimeout(timeout);
        return this;
    }

    @Override
    public IgniteCompute withNoFailover() {
        this.compute.withNoFailover();
        return this;
    }

    @Override
    public IgniteCompute withNoResultCache() {
        this.compute.withNoResultCache();
        return this;
    }

    @Override
    public void localDeployTask(Class<? extends ComputeTask> taskCls, ClassLoader clsLdr) {
        A.notNull(taskCls, "taskCls", clsLdr, "clsLdr");
        this.guard();
        try {
            GridDeployment dep = this.ctx.deploy().deploy(taskCls, clsLdr);
            if (dep == null) {
                throw new IgniteDeploymentException("Failed to deploy task (was task (re|un)deployed?): " + taskCls);
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Map<String, Class<? extends ComputeTask<?, ?>>> localTasks() {
        this.guard();
        try {
            Map<String, Class<? extends ComputeTask<?, ?>>> map = this.ctx.deploy().findAllTasks(new IgnitePredicate[0]);
            return map;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void undeployTask(String taskName) {
        A.notNull(taskName, "taskName");
        this.guard();
        try {
            this.ctx.deploy().undeployTask(taskName, this.prj.node(this.ctx.localNodeId()) != null, this.prj.forRemotes().nodes());
        }
        finally {
            this.unguard();
        }
    }

    private void guard() {
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        this.ctx.gateway().readUnlock();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prj);
        out.writeObject(this.execName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prj = (ClusterGroupAdapter)in.readObject();
        this.execName = (String)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.execName == null ? this.prj.compute() : this.prj.compute().withExecutor(this.execName);
    }

    @Override
    protected <R> IgniteFuture<R> createFuture(IgniteInternalFuture<R> fut) {
        assert (fut instanceof ComputeTaskInternalFuture) : fut;
        return ((ComputeTaskInternalFuture)fut).publicFuture();
    }

    @Override
    public <R> ComputeTaskFuture<R> future() {
        return (ComputeTaskFuture)super.future();
    }

    @Override
    public IgniteCompute withExecutor(@NotNull String name) {
        return new IgniteComputeImpl(this.ctx, this.prj, this.isAsync(), name, this.compute);
    }

    private TaskExecutionOptions enrichOptions(TaskExecutionOptions opts) {
        if (this.execName != null) {
            opts.withExecutor(this.execName);
        }
        return opts.asPublicRequest().withProjection(this.prj.nodes());
    }
}

