/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.direct.stream;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class DirectByteBufferStream {
    private static final byte[] BYTE_ARR_EMPTY = new byte[0];
    private static final short[] SHORT_ARR_EMPTY = new short[0];
    private static final int[] INT_ARR_EMPTY = U.EMPTY_INTS;
    private static final long[] LONG_ARR_EMPTY = U.EMPTY_LONGS;
    private static final float[] FLOAT_ARR_EMPTY = new float[0];
    private static final double[] DOUBLE_ARR_EMPTY = new double[0];
    private static final char[] CHAR_ARR_EMPTY = new char[0];
    private static final boolean[] BOOLEAN_ARR_EMPTY = new boolean[0];
    private static final ArrayCreator<byte[]> BYTE_ARR_CREATOR = new ArrayCreator<byte[]>(){

        @Override
        public byte[] create(int len) {
            if (len < 0) {
                throw new IgniteException("Read invalid byte array length: " + len);
            }
            switch (len) {
                case 0: {
                    return BYTE_ARR_EMPTY;
                }
            }
            return new byte[len];
        }
    };
    private static final ArrayCreator<short[]> SHORT_ARR_CREATOR = new ArrayCreator<short[]>(){

        @Override
        public short[] create(int len) {
            if (len < 0) {
                throw new IgniteException("Read invalid short array length: " + len);
            }
            switch (len) {
                case 0: {
                    return SHORT_ARR_EMPTY;
                }
            }
            return new short[len];
        }
    };
    private static final ArrayCreator<int[]> INT_ARR_CREATOR = new ArrayCreator<int[]>(){

        @Override
        public int[] create(int len) {
            if (len < 0) {
                throw new IgniteException("Read invalid int array length: " + len);
            }
            switch (len) {
                case 0: {
                    return INT_ARR_EMPTY;
                }
            }
            return new int[len];
        }
    };
    private static final ArrayCreator<long[]> LONG_ARR_CREATOR = new ArrayCreator<long[]>(){

        @Override
        public long[] create(int len) {
            if (len < 0) {
                throw new IgniteException("Read invalid long array length: " + len);
            }
            switch (len) {
                case 0: {
                    return LONG_ARR_EMPTY;
                }
            }
            return new long[len];
        }
    };
    private static final ArrayCreator<float[]> FLOAT_ARR_CREATOR = new ArrayCreator<float[]>(){

        @Override
        public float[] create(int len) {
            if (len < 0) {
                throw new IgniteException("Read invalid float array length: " + len);
            }
            switch (len) {
                case 0: {
                    return FLOAT_ARR_EMPTY;
                }
            }
            return new float[len];
        }
    };
    private static final ArrayCreator<double[]> DOUBLE_ARR_CREATOR = new ArrayCreator<double[]>(){

        @Override
        public double[] create(int len) {
            if (len < 0) {
                throw new IgniteException("Read invalid double array length: " + len);
            }
            switch (len) {
                case 0: {
                    return DOUBLE_ARR_EMPTY;
                }
            }
            return new double[len];
        }
    };
    private static final ArrayCreator<char[]> CHAR_ARR_CREATOR = new ArrayCreator<char[]>(){

        @Override
        public char[] create(int len) {
            if (len < 0) {
                throw new IgniteException("Read invalid char array length: " + len);
            }
            switch (len) {
                case 0: {
                    return CHAR_ARR_EMPTY;
                }
            }
            return new char[len];
        }
    };
    private static final ArrayCreator<boolean[]> BOOLEAN_ARR_CREATOR = new ArrayCreator<boolean[]>(){

        @Override
        public boolean[] create(int len) {
            if (len < 0) {
                throw new IgniteException("Read invalid boolean array length: " + len);
            }
            switch (len) {
                case 0: {
                    return BOOLEAN_ARR_EMPTY;
                }
            }
            return new boolean[len];
        }
    };
    private static final Object NULL = new Object();
    @GridToStringExclude
    private final MessageFactory msgFactory;
    @GridToStringExclude
    protected ByteBuffer buf;
    protected byte[] heapArr;
    protected long baseOff;
    private int arrOff = -1;
    private Object tmpArr;
    private int tmpArrOff;
    private int valReadBytes;
    private int tmpArrBytes;
    private boolean msgTypeDone;
    private Message msg;
    private Iterator<?> mapIt;
    private Iterator<?> it;
    private int arrPos = -1;
    private Object arrCur = NULL;
    private Object mapCur = NULL;
    private Object cur = NULL;
    private boolean keyDone;
    private int readSize = -1;
    private int readItems;
    private Object[] objArr;
    private Collection<Object> col;
    private Map<Object, Object> map;
    private long prim;
    private int primShift;
    protected int uuidState;
    protected long uuidMost;
    protected long uuidLeast;
    protected long uuidLocId;
    protected boolean lastFinished;
    private byte[] curStrBackingArr;
    private byte topVerState;
    private long topVerMajor;
    private int topVerMinor;

    public DirectByteBufferStream(MessageFactory msgFactory) {
        this.msgFactory = msgFactory;
    }

    public void setBuffer(ByteBuffer buf) {
        assert (buf != null);
        if (this.buf != buf) {
            this.buf = buf;
            this.heapArr = buf.isDirect() ? null : buf.array();
            this.baseOff = buf.isDirect() ? GridUnsafe.bufferAddress(buf) : GridUnsafe.BYTE_ARR_OFF;
        }
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public boolean lastFinished() {
        return this.lastFinished;
    }

    public void writeByte(byte val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 1;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 1);
        }
    }

    public void writeShort(short val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            long off = this.baseOff + (long)pos;
            if (GridUnsafe.BIG_ENDIAN) {
                GridUnsafe.putShortLE(this.heapArr, off, val);
            } else {
                GridUnsafe.putShort(this.heapArr, off, val);
            }
            this.buf.position(pos + 2);
        }
    }

    public void writeInt(int val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 5;
        if (this.lastFinished) {
            val = val == Integer.MAX_VALUE ? Integer.MIN_VALUE : ++val;
            int pos = this.buf.position();
            while ((val & 0xFFFFFF80) != 0) {
                byte b = (byte)(val | 0x80);
                GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, b);
                val >>>= 7;
            }
            GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, (byte)val);
            this.buf.position(pos);
        }
    }

    public void writeLong(long val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 10;
        if (this.lastFinished) {
            val = val == Long.MAX_VALUE ? Long.MIN_VALUE : ++val;
            int pos = this.buf.position();
            while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
                byte b = (byte)(val | 0x80L);
                GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, b);
                val >>>= 7;
            }
            GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, (byte)val);
            this.buf.position(pos);
        }
    }

    public void writeFloat(float val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 4;
        if (this.lastFinished) {
            int pos = this.buf.position();
            long off = this.baseOff + (long)pos;
            if (GridUnsafe.BIG_ENDIAN) {
                GridUnsafe.putFloatLE(this.heapArr, off, val);
            } else {
                GridUnsafe.putFloat(this.heapArr, off, val);
            }
            this.buf.position(pos + 4);
        }
    }

    public void writeDouble(double val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 8;
        if (this.lastFinished) {
            int pos = this.buf.position();
            long off = this.baseOff + (long)pos;
            if (GridUnsafe.BIG_ENDIAN) {
                GridUnsafe.putDoubleLE(this.heapArr, off, val);
            } else {
                GridUnsafe.putDouble(this.heapArr, off, val);
            }
            this.buf.position(pos + 8);
        }
    }

    public void writeChar(char val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            long off = this.baseOff + (long)pos;
            if (GridUnsafe.BIG_ENDIAN) {
                GridUnsafe.putCharLE(this.heapArr, off, val);
            } else {
                GridUnsafe.putChar(this.heapArr, off, val);
            }
            this.buf.position(pos + 2);
        }
    }

    public void writeBoolean(boolean val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 1;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putBoolean(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 1);
        }
    }

    public void writeByteArray(byte[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.BYTE_ARR_OFF, val.length, val.length);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeByteArray(byte[] val, long off, int len) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.BYTE_ARR_OFF + off, len, len);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeShortArray(short[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.BIG_ENDIAN ? this.writeArrayLE(val, GridUnsafe.SHORT_ARR_OFF, val.length, 2, 1) : this.writeArray(val, GridUnsafe.SHORT_ARR_OFF, val.length, val.length << 1);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeIntArray(int[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.BIG_ENDIAN ? this.writeArrayLE(val, GridUnsafe.INT_ARR_OFF, val.length, 4, 2) : this.writeArray(val, GridUnsafe.INT_ARR_OFF, val.length, val.length << 2);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeLongArray(long[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.BIG_ENDIAN ? this.writeArrayLE(val, GridUnsafe.LONG_ARR_OFF, val.length, 8, 3) : this.writeArray(val, GridUnsafe.LONG_ARR_OFF, val.length, val.length << 3);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeLongArray(long[] val, int len) {
        if (val != null) {
            this.lastFinished = GridUnsafe.BIG_ENDIAN ? this.writeArrayLE(val, GridUnsafe.LONG_ARR_OFF, len, 8, 3) : this.writeArray(val, GridUnsafe.LONG_ARR_OFF, len, len << 3);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeFloatArray(float[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.BIG_ENDIAN ? this.writeArrayLE(val, GridUnsafe.FLOAT_ARR_OFF, val.length, 4, 2) : this.writeArray(val, GridUnsafe.FLOAT_ARR_OFF, val.length, val.length << 2);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeDoubleArray(double[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.BIG_ENDIAN ? this.writeArrayLE(val, GridUnsafe.DOUBLE_ARR_OFF, val.length, 8, 3) : this.writeArray(val, GridUnsafe.DOUBLE_ARR_OFF, val.length, val.length << 3);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeCharArray(char[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.BIG_ENDIAN ? this.writeArrayLE(val, GridUnsafe.CHAR_ARR_OFF, val.length, 2, 1) : this.writeArray(val, GridUnsafe.CHAR_ARR_OFF, val.length, val.length << 1);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeBooleanArray(boolean[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.BOOLEAN_ARR_OFF, val.length, val.length);
        } else {
            this.writeInt(-1);
        }
    }

    public void writeString(String val) {
        if (val != null) {
            if (this.curStrBackingArr == null) {
                this.curStrBackingArr = val.getBytes();
            }
            this.writeByteArray(this.curStrBackingArr);
            if (this.lastFinished) {
                this.curStrBackingArr = null;
            }
        } else {
            this.writeByteArray(null);
        }
    }

    public void writeBitSet(BitSet val) {
        this.writeLongArray(val != null ? val.toLongArray() : null);
    }

    public void writeUuid(UUID val) {
        switch (this.uuidState) {
            case 0: {
                this.writeBoolean(val == null);
                if (!this.lastFinished || val == null) {
                    return;
                }
                ++this.uuidState;
            }
            case 1: {
                this.writeUuidRaw(val);
                if (!this.lastFinished) {
                    return;
                }
                this.uuidState = 0;
            }
        }
    }

    public void writeIgniteUuid(IgniteUuid val) {
        switch (this.uuidState) {
            case 0: {
                this.writeBoolean(val == null);
                if (!this.lastFinished || val == null) {
                    return;
                }
                ++this.uuidState;
            }
            case 1: {
                this.writeLong(val.globalId().getMostSignificantBits());
                if (!this.lastFinished) {
                    return;
                }
                ++this.uuidState;
            }
            case 2: {
                this.writeLong(val.globalId().getLeastSignificantBits());
                if (!this.lastFinished) {
                    return;
                }
                ++this.uuidState;
            }
            case 3: {
                this.writeLong(val.localId());
                if (!this.lastFinished) {
                    return;
                }
                this.uuidState = 0;
            }
        }
    }

    public void writeAffinityTopologyVersion(AffinityTopologyVersion val) {
        if (val != null) {
            switch (this.topVerState) {
                case 0: {
                    this.writeInt(val.minorTopologyVersion());
                    if (!this.lastFinished) {
                        return;
                    }
                    this.topVerState = (byte)(this.topVerState + 1);
                }
                case 1: {
                    this.writeLong(val.topologyVersion());
                    if (!this.lastFinished) {
                        return;
                    }
                    this.topVerState = 0;
                }
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeMessage(Message msg, MessageWriter writer) {
        if (msg != null) {
            if (this.buf.hasRemaining()) {
                try {
                    writer.beforeInnerMessageWrite();
                    writer.setCurrentWriteClass(msg.getClass());
                    this.lastFinished = msg.writeTo(this.buf, writer);
                }
                finally {
                    writer.afterInnerMessageWrite(this.lastFinished);
                }
            } else {
                this.lastFinished = false;
            }
        } else {
            this.writeShort((short)Short.MIN_VALUE);
        }
    }

    public <T> void writeObjectArray(T[] arr, MessageCollectionItemType itemType, MessageWriter writer) {
        if (arr != null) {
            int len = arr.length;
            if (this.arrPos == -1) {
                this.writeInt(len);
                if (!this.lastFinished) {
                    return;
                }
                this.arrPos = 0;
            }
            while (this.arrPos < len || this.arrCur != NULL) {
                if (this.arrCur == NULL) {
                    this.arrCur = arr[this.arrPos++];
                }
                this.write(itemType, this.arrCur, writer);
                if (!this.lastFinished) {
                    return;
                }
                this.arrCur = NULL;
            }
            this.arrPos = -1;
        } else {
            this.writeInt(-1);
        }
    }

    public <T> void writeCollection(Collection<T> col, MessageCollectionItemType itemType, MessageWriter writer) {
        if (col != null) {
            if (col instanceof List && col instanceof RandomAccess) {
                this.writeRandomAccessList((List)col, itemType, writer);
            } else {
                if (this.it == null) {
                    this.writeInt(col.size());
                    if (!this.lastFinished) {
                        return;
                    }
                    this.it = col.iterator();
                }
                while (this.it.hasNext() || this.cur != NULL) {
                    if (this.cur == NULL) {
                        this.cur = this.it.next();
                    }
                    this.write(itemType, this.cur, writer);
                    if (!this.lastFinished) {
                        return;
                    }
                    this.cur = NULL;
                }
                this.it = null;
            }
        } else {
            this.writeInt(-1);
        }
    }

    private <T> void writeRandomAccessList(List<T> list, MessageCollectionItemType itemType, MessageWriter writer) {
        assert (list instanceof RandomAccess);
        int size = list.size();
        if (this.arrPos == -1) {
            this.writeInt(size);
            if (!this.lastFinished) {
                return;
            }
            this.arrPos = 0;
        }
        while (this.arrPos < size || this.arrCur != NULL) {
            if (this.arrCur == NULL) {
                this.arrCur = list.get(this.arrPos++);
            }
            this.write(itemType, this.arrCur, writer);
            if (!this.lastFinished) {
                return;
            }
            this.arrCur = NULL;
        }
        this.arrPos = -1;
    }

    public <K, V> void writeMap(Map<K, V> map, MessageCollectionItemType keyType, MessageCollectionItemType valType, MessageWriter writer) {
        if (map != null) {
            if (this.mapIt == null) {
                this.writeInt(map.size());
                if (!this.lastFinished) {
                    return;
                }
                this.mapIt = map.entrySet().iterator();
            }
            while (this.mapIt.hasNext() || this.mapCur != NULL) {
                if (this.mapCur == NULL) {
                    this.mapCur = this.mapIt.next();
                }
                Map.Entry e = (Map.Entry)this.mapCur;
                if (!this.keyDone) {
                    this.write(keyType, e.getKey(), writer);
                    if (!this.lastFinished) {
                        return;
                    }
                    this.keyDone = true;
                }
                this.write(valType, e.getValue(), writer);
                if (!this.lastFinished) {
                    return;
                }
                this.mapCur = NULL;
                this.keyDone = false;
            }
            this.mapIt = null;
        } else {
            this.writeInt(-1);
        }
    }

    public byte readByte() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 1;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 1);
            return GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos);
        }
        return 0;
    }

    public short readShort() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 2);
            long off = this.baseOff + (long)pos;
            return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getShortLE(this.heapArr, off) : GridUnsafe.getShort(this.heapArr, off);
        }
        return 0;
    }

    public int readInt() {
        this.lastFinished = false;
        int val = 0;
        while (this.buf.hasRemaining()) {
            int pos = this.buf.position();
            byte b = GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos);
            this.buf.position(pos + 1);
            this.prim |= ((long)b & 0x7FL) << 7 * this.primShift;
            if ((b & 0x80) == 0) {
                this.lastFinished = true;
                val = (int)this.prim;
                val = val == Integer.MIN_VALUE ? Integer.MAX_VALUE : --val;
                this.prim = 0L;
                this.primShift = 0;
                break;
            }
            ++this.primShift;
        }
        return val;
    }

    public long readLong() {
        this.lastFinished = false;
        long val = 0L;
        while (this.buf.hasRemaining()) {
            int pos = this.buf.position();
            byte b = GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos);
            this.buf.position(pos + 1);
            this.prim |= ((long)b & 0x7FL) << 7 * this.primShift;
            if ((b & 0x80) == 0) {
                this.lastFinished = true;
                val = this.prim;
                val = val == Long.MIN_VALUE ? Long.MAX_VALUE : --val;
                this.prim = 0L;
                this.primShift = 0;
                break;
            }
            ++this.primShift;
        }
        return val;
    }

    public float readFloat() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 4;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 4);
            long off = this.baseOff + (long)pos;
            return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getFloatLE(this.heapArr, off) : GridUnsafe.getFloat(this.heapArr, off);
        }
        return 0.0f;
    }

    public double readDouble() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 8;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 8);
            long off = this.baseOff + (long)pos;
            return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getDoubleLE(this.heapArr, off) : GridUnsafe.getDouble(this.heapArr, off);
        }
        return 0.0;
    }

    public char readChar() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 2);
            long off = this.baseOff + (long)pos;
            return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getCharLE(this.heapArr, off) : GridUnsafe.getChar(this.heapArr, off);
        }
        return '\u0000';
    }

    public boolean readBoolean() {
        this.lastFinished = this.buf.hasRemaining();
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 1);
            return GridUnsafe.getBoolean(this.heapArr, this.baseOff + (long)pos);
        }
        return false;
    }

    public byte[] readByteArray() {
        return this.readArray(BYTE_ARR_CREATOR, 0, GridUnsafe.BYTE_ARR_OFF);
    }

    public short[] readShortArray() {
        if (GridUnsafe.BIG_ENDIAN) {
            return this.readArrayLE(SHORT_ARR_CREATOR, 2, 1, GridUnsafe.SHORT_ARR_OFF);
        }
        return this.readArray(SHORT_ARR_CREATOR, 1, GridUnsafe.SHORT_ARR_OFF);
    }

    public int[] readIntArray() {
        if (GridUnsafe.BIG_ENDIAN) {
            return this.readArrayLE(INT_ARR_CREATOR, 4, 2, GridUnsafe.INT_ARR_OFF);
        }
        return this.readArray(INT_ARR_CREATOR, 2, GridUnsafe.INT_ARR_OFF);
    }

    public long[] readLongArray() {
        if (GridUnsafe.BIG_ENDIAN) {
            return this.readArrayLE(LONG_ARR_CREATOR, 8, 3, GridUnsafe.LONG_ARR_OFF);
        }
        return this.readArray(LONG_ARR_CREATOR, 3, GridUnsafe.LONG_ARR_OFF);
    }

    public float[] readFloatArray() {
        if (GridUnsafe.BIG_ENDIAN) {
            return this.readArrayLE(FLOAT_ARR_CREATOR, 4, 2, GridUnsafe.FLOAT_ARR_OFF);
        }
        return this.readArray(FLOAT_ARR_CREATOR, 2, GridUnsafe.FLOAT_ARR_OFF);
    }

    public double[] readDoubleArray() {
        if (GridUnsafe.BIG_ENDIAN) {
            return this.readArrayLE(DOUBLE_ARR_CREATOR, 8, 3, GridUnsafe.DOUBLE_ARR_OFF);
        }
        return this.readArray(DOUBLE_ARR_CREATOR, 3, GridUnsafe.DOUBLE_ARR_OFF);
    }

    public char[] readCharArray() {
        if (GridUnsafe.BIG_ENDIAN) {
            return this.readArrayLE(CHAR_ARR_CREATOR, 2, 1, GridUnsafe.CHAR_ARR_OFF);
        }
        return this.readArray(CHAR_ARR_CREATOR, 1, GridUnsafe.CHAR_ARR_OFF);
    }

    public boolean[] readBooleanArray() {
        return this.readArray(BOOLEAN_ARR_CREATOR, 0, GridUnsafe.BOOLEAN_ARR_OFF);
    }

    public String readString() {
        byte[] arr = this.readByteArray();
        return arr != null ? new String(arr) : null;
    }

    public BitSet readBitSet() {
        long[] arr = this.readLongArray();
        return arr != null ? BitSet.valueOf(arr) : null;
    }

    public UUID readUuid() {
        switch (this.uuidState) {
            case 0: {
                boolean isNull = this.readBoolean();
                if (!this.lastFinished || isNull) {
                    return null;
                }
                ++this.uuidState;
            }
            case 1: {
                this.readUuidRaw();
                if (!this.lastFinished) {
                    return null;
                }
                this.uuidState = 0;
            }
        }
        UUID val = new UUID(this.uuidMost, this.uuidLeast);
        this.uuidMost = 0L;
        this.uuidLeast = 0L;
        return val;
    }

    public IgniteUuid readIgniteUuid() {
        switch (this.uuidState) {
            case 0: {
                boolean isNull = this.readBoolean();
                if (!this.lastFinished || isNull) {
                    return null;
                }
                ++this.uuidState;
            }
            case 1: {
                this.uuidMost = this.readLong();
                if (!this.lastFinished) {
                    return null;
                }
                ++this.uuidState;
            }
            case 2: {
                this.uuidLeast = this.readLong();
                if (!this.lastFinished) {
                    return null;
                }
                ++this.uuidState;
            }
            case 3: {
                this.uuidLocId = this.readLong();
                if (!this.lastFinished) {
                    return null;
                }
                this.uuidState = 0;
            }
        }
        IgniteUuid val = new IgniteUuid(new UUID(this.uuidMost, this.uuidLeast), this.uuidLocId);
        this.uuidMost = 0L;
        this.uuidLeast = 0L;
        this.uuidLocId = 0L;
        return val;
    }

    public AffinityTopologyVersion readAffinityTopologyVersion() {
        switch (this.topVerState) {
            case 0: {
                this.topVerMinor = this.readInt();
                if (!this.lastFinished || this.topVerMinor == -1) {
                    return null;
                }
                this.topVerState = (byte)(this.topVerState + 1);
            }
            case 1: {
                this.topVerMajor = this.readLong();
                if (!this.lastFinished) {
                    return null;
                }
                this.topVerState = 0;
            }
        }
        return new AffinityTopologyVersion(this.topVerMajor, this.topVerMinor);
    }

    public <T extends Message> T readMessage(MessageReader reader) {
        if (!this.msgTypeDone) {
            if (this.buf.remaining() < 2) {
                this.lastFinished = false;
                return null;
            }
            short type = this.readShort();
            this.msg = type == Short.MIN_VALUE ? null : this.msgFactory.create(type);
            this.msgTypeDone = true;
        }
        if (this.msg != null) {
            try {
                reader.beforeInnerMessageRead();
                reader.setCurrentReadClass(this.msg.getClass());
                this.lastFinished = this.msg.readFrom(this.buf, reader);
            }
            finally {
                reader.afterInnerMessageRead(this.lastFinished);
            }
        } else {
            this.lastFinished = true;
        }
        if (this.lastFinished) {
            Message msg0 = this.msg;
            this.msgTypeDone = false;
            this.msg = null;
            return (T)msg0;
        }
        return null;
    }

    public <T> T[] readObjectArray(MessageCollectionItemType itemType, Class<T> itemCls, MessageReader reader) {
        if (this.readSize == -1) {
            int size = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            this.readSize = size;
        }
        if (this.readSize >= 0) {
            if (this.objArr == null) {
                this.objArr = itemCls != null ? (Object[])Array.newInstance(itemCls, this.readSize) : new Object[this.readSize];
            }
            for (int i = this.readItems; i < this.readSize; ++i) {
                Object item = this.read(itemType, reader);
                if (!this.lastFinished) {
                    return null;
                }
                this.objArr[i] = item;
                ++this.readItems;
            }
        }
        this.readSize = -1;
        this.readItems = 0;
        this.cur = null;
        Object[] objArr0 = this.objArr;
        this.objArr = null;
        return objArr0;
    }

    public <C extends Collection<?>> C readCollection(MessageCollectionItemType itemType, MessageReader reader) {
        if (this.readSize == -1) {
            int size = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            this.readSize = size;
        }
        if (this.readSize >= 0) {
            if (this.col == null) {
                this.col = new ArrayList<Object>(this.readSize);
            }
            for (int i = this.readItems; i < this.readSize; ++i) {
                Object item = this.read(itemType, reader);
                if (!this.lastFinished) {
                    return null;
                }
                this.col.add(item);
                ++this.readItems;
            }
        }
        this.readSize = -1;
        this.readItems = 0;
        this.cur = null;
        Collection<Object> col0 = this.col;
        this.col = null;
        return (C)col0;
    }

    public <M extends Map<?, ?>> M readMap(MessageCollectionItemType keyType, MessageCollectionItemType valType, boolean linked, MessageReader reader) {
        if (this.readSize == -1) {
            int size = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            this.readSize = size;
        }
        if (this.readSize >= 0) {
            if (this.map == null) {
                this.map = linked ? U.newLinkedHashMap(this.readSize) : U.newHashMap(this.readSize);
            }
            for (int i = this.readItems; i < this.readSize; ++i) {
                if (!this.keyDone) {
                    Object key = this.read(keyType, reader);
                    if (!this.lastFinished) {
                        return null;
                    }
                    this.mapCur = key;
                    this.keyDone = true;
                }
                Object val = this.read(valType, reader);
                if (!this.lastFinished) {
                    return null;
                }
                this.map.put(this.mapCur, val);
                this.keyDone = false;
                ++this.readItems;
            }
        }
        this.readSize = -1;
        this.readItems = 0;
        this.mapCur = null;
        Map<Object, Object> map0 = this.map;
        this.map = null;
        return (M)map0;
    }

    boolean writeArray(Object arr, long off, int len, int bytes) {
        assert (arr != null);
        assert (arr.getClass().isArray() && arr.getClass().getComponentType().isPrimitive());
        assert (off > 0L);
        assert (len >= 0);
        assert (bytes >= 0);
        assert (bytes >= this.arrOff);
        if (this.writeArrayLength(len)) {
            return false;
        }
        int toWrite = bytes - this.arrOff;
        int pos = this.buf.position();
        int remaining = this.buf.remaining();
        if (toWrite <= remaining) {
            if (toWrite > 0) {
                GridUnsafe.copyMemory(arr, off + (long)this.arrOff, this.heapArr, this.baseOff + (long)pos, toWrite);
                this.buf.position(pos + toWrite);
            }
            this.arrOff = -1;
            return true;
        }
        if (remaining > 0) {
            GridUnsafe.copyMemory(arr, off + (long)this.arrOff, this.heapArr, this.baseOff + (long)pos, remaining);
            this.buf.position(pos + remaining);
            this.arrOff += remaining;
        }
        return false;
    }

    boolean writeArrayLE(Object arr, long off, int len, int typeSize, int shiftCnt) {
        assert (arr != null);
        assert (arr.getClass().isArray() && arr.getClass().getComponentType().isPrimitive());
        assert (off > 0L);
        assert (len >= 0);
        int bytes = len << shiftCnt;
        assert (bytes >= this.arrOff);
        if (this.writeArrayLength(len)) {
            return false;
        }
        int toWrite = bytes - this.arrOff >> shiftCnt;
        int remaining = this.buf.remaining() >> shiftCnt;
        if (toWrite <= remaining) {
            this.writeArrayLE(arr, off, toWrite, typeSize);
            this.arrOff = -1;
            return true;
        }
        if (remaining > 0) {
            this.writeArrayLE(arr, off, remaining, typeSize);
        }
        return false;
    }

    private void writeArrayLE(Object arr, long off, int len, int typeSize) {
        int pos = this.buf.position();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < typeSize; ++j) {
                byte b = GridUnsafe.getByteField(arr, off + (long)this.arrOff + (long)(typeSize - j - 1));
                GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, b);
            }
            this.buf.position(pos);
            this.arrOff += typeSize;
        }
    }

    private boolean writeArrayLength(int len) {
        if (this.arrOff == -1) {
            this.writeInt(len);
            if (!this.lastFinished) {
                return true;
            }
            this.arrOff = 0;
        }
        return false;
    }

    <T> T readArray(ArrayCreator<T> creator, int lenShift, long off) {
        assert (creator != null);
        if (this.tmpArr == null) {
            int len = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            switch (len) {
                case -1: {
                    this.lastFinished = true;
                    return null;
                }
                case 0: {
                    this.lastFinished = true;
                    return creator.create(0);
                }
            }
            this.tmpArr = creator.create(len);
            this.tmpArrBytes = len << lenShift;
        }
        int toRead = this.tmpArrBytes - this.tmpArrOff;
        int remaining = this.buf.remaining();
        int pos = this.buf.position();
        boolean bl = this.lastFinished = toRead <= remaining;
        if (this.lastFinished) {
            GridUnsafe.copyMemory(this.heapArr, this.baseOff + (long)pos, this.tmpArr, off + (long)this.tmpArrOff, toRead);
            this.buf.position(pos + toRead);
            Object arr = this.tmpArr;
            this.tmpArr = null;
            this.tmpArrBytes = 0;
            this.tmpArrOff = 0;
            return (T)arr;
        }
        GridUnsafe.copyMemory(this.heapArr, this.baseOff + (long)pos, this.tmpArr, off + (long)this.tmpArrOff, remaining);
        this.buf.position(pos + remaining);
        this.tmpArrOff += remaining;
        return null;
    }

    <T> T readArrayLE(ArrayCreator<T> creator, int typeSize, int lenShift, long off) {
        int remaining;
        int toRead;
        assert (creator != null);
        if (this.tmpArr == null) {
            int len = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            switch (len) {
                case -1: {
                    this.lastFinished = true;
                    return null;
                }
                case 0: {
                    this.lastFinished = true;
                    return creator.create(0);
                }
            }
            this.tmpArr = creator.create(len);
            this.tmpArrBytes = len << lenShift;
        }
        boolean bl = this.lastFinished = (toRead = this.tmpArrBytes - this.tmpArrOff - this.valReadBytes) <= (remaining = this.buf.remaining());
        if (!this.lastFinished) {
            toRead = remaining;
        }
        int pos = this.buf.position();
        for (int i = 0; i < toRead; ++i) {
            byte b = GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos + (long)i);
            GridUnsafe.putByteField(this.tmpArr, off + (long)this.tmpArrOff + (long)(typeSize - this.valReadBytes - 1), b);
            if (++this.valReadBytes != typeSize) continue;
            this.valReadBytes = 0;
            this.tmpArrOff += typeSize;
        }
        this.buf.position(pos + toRead);
        if (this.lastFinished) {
            Object arr = this.tmpArr;
            this.tmpArr = null;
            this.tmpArrBytes = 0;
            this.tmpArrOff = 0;
            return (T)arr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(MessageCollectionItemType type, Object val, MessageWriter writer) {
        switch (type) {
            case BYTE: {
                this.writeByte((Byte)val);
                break;
            }
            case SHORT: {
                this.writeShort((Short)val);
                break;
            }
            case INT: {
                this.writeInt((Integer)val);
                break;
            }
            case LONG: {
                this.writeLong((Long)val);
                break;
            }
            case FLOAT: {
                this.writeFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                this.writeDouble((Double)val);
                break;
            }
            case CHAR: {
                this.writeChar(((Character)val).charValue());
                break;
            }
            case BOOLEAN: {
                this.writeBoolean((Boolean)val);
                break;
            }
            case BYTE_ARR: {
                this.writeByteArray((byte[])val);
                break;
            }
            case SHORT_ARR: {
                this.writeShortArray((short[])val);
                break;
            }
            case INT_ARR: {
                this.writeIntArray((int[])val);
                break;
            }
            case LONG_ARR: {
                this.writeLongArray((long[])val);
                break;
            }
            case FLOAT_ARR: {
                this.writeFloatArray((float[])val);
                break;
            }
            case DOUBLE_ARR: {
                this.writeDoubleArray((double[])val);
                break;
            }
            case CHAR_ARR: {
                this.writeCharArray((char[])val);
                break;
            }
            case BOOLEAN_ARR: {
                this.writeBooleanArray((boolean[])val);
                break;
            }
            case STRING: {
                this.writeString((String)val);
                break;
            }
            case BIT_SET: {
                this.writeBitSet((BitSet)val);
                break;
            }
            case UUID: {
                this.writeUuid((UUID)val);
                break;
            }
            case IGNITE_UUID: {
                this.writeIgniteUuid((IgniteUuid)val);
                break;
            }
            case AFFINITY_TOPOLOGY_VERSION: {
                this.writeAffinityTopologyVersion((AffinityTopologyVersion)val);
                break;
            }
            case MSG: {
                try {
                    if (val != null) {
                        writer.beforeInnerMessageWrite();
                    }
                    this.writeMessage((Message)val, writer);
                    break;
                }
                finally {
                    if (val != null) {
                        writer.afterInnerMessageWrite(this.lastFinished);
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        }
    }

    protected Object read(MessageCollectionItemType type, MessageReader reader) {
        switch (type) {
            case BYTE: {
                return this.readByte();
            }
            case SHORT: {
                return this.readShort();
            }
            case INT: {
                return this.readInt();
            }
            case LONG: {
                return this.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case CHAR: {
                return Character.valueOf(this.readChar());
            }
            case BOOLEAN: {
                return this.readBoolean();
            }
            case BYTE_ARR: {
                return this.readByteArray();
            }
            case SHORT_ARR: {
                return this.readShortArray();
            }
            case INT_ARR: {
                return this.readIntArray();
            }
            case LONG_ARR: {
                return this.readLongArray();
            }
            case FLOAT_ARR: {
                return this.readFloatArray();
            }
            case DOUBLE_ARR: {
                return this.readDoubleArray();
            }
            case CHAR_ARR: {
                return this.readCharArray();
            }
            case BOOLEAN_ARR: {
                return this.readBooleanArray();
            }
            case STRING: {
                return this.readString();
            }
            case BIT_SET: {
                return this.readBitSet();
            }
            case UUID: {
                return this.readUuid();
            }
            case IGNITE_UUID: {
                return this.readIgniteUuid();
            }
            case AFFINITY_TOPOLOGY_VERSION: {
                return this.readAffinityTopologyVersion();
            }
            case MSG: {
                return this.readMessage(reader);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    private void writeUuidRaw(UUID val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 16;
        if (this.lastFinished) {
            int pos = this.buf.position();
            long off = this.baseOff + (long)pos;
            if (GridUnsafe.BIG_ENDIAN) {
                GridUnsafe.putLongLE(this.heapArr, off, val.getMostSignificantBits());
                GridUnsafe.putLongLE(this.heapArr, off + 8L, val.getLeastSignificantBits());
            } else {
                GridUnsafe.putLong(this.heapArr, off, val.getMostSignificantBits());
                GridUnsafe.putLong(this.heapArr, off + 8L, val.getLeastSignificantBits());
            }
            this.buf.position(pos + 16);
        }
    }

    private void readUuidRaw() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 16;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 16);
            long off = this.baseOff + (long)pos;
            if (GridUnsafe.BIG_ENDIAN) {
                this.uuidMost = GridUnsafe.getLongLE(this.heapArr, off);
                this.uuidLeast = GridUnsafe.getLongLE(this.heapArr, off + 8L);
            } else {
                this.uuidMost = GridUnsafe.getLong(this.heapArr, off);
                this.uuidLeast = GridUnsafe.getLong(this.heapArr, off + 8L);
            }
        }
    }

    public String toString() {
        return S.toString(DirectByteBufferStream.class, this);
    }

    static interface ArrayCreator<T> {
        public T create(int var1);
    }
}

