/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.cache.CacheConfiguration;
import org.apache.ignite.internal.management.cache.CacheConfigurationCollectorJob;
import org.apache.ignite.internal.management.cache.CacheConfigurationCollectorTaskArg;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CacheConfigurationCollectorTask
extends VisorOneNodeTask<CacheConfigurationCollectorTaskArg, Map<String, CacheConfiguration>> {
    private static final long serialVersionUID = 0L;

    protected CacheConfigurationCollectorJob job(CacheConfigurationCollectorTaskArg arg) {
        return new CacheConfigurationCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<String, CacheConfiguration> reduce0(List<ComputeJobResult> results) throws IgniteException {
        if (results == null) {
            return null;
        }
        HashMap<String, CacheConfiguration> map = new HashMap<String, CacheConfiguration>();
        ArrayList<IgniteException> resultsExceptions = null;
        for (ComputeJobResult res : results) {
            if (res.getException() == null) {
                map.putAll((Map)res.getData());
                continue;
            }
            if (resultsExceptions == null) {
                resultsExceptions = new ArrayList<IgniteException>(results.size());
            }
            resultsExceptions.add(new IgniteException("Job failed on node: " + res.getNode().id(), res.getException()));
        }
        if (resultsExceptions != null) {
            IgniteException e = new IgniteException("Reduce failed because of job failed on some nodes");
            for (Exception exception : resultsExceptions) {
                e.addSuppressed(exception);
            }
            throw e;
        }
        return map;
    }
}

