/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.cache.CacheFindGarbageCommandArg;
import org.apache.ignite.internal.management.cache.FindAndDeleteGarbageInPersistenceClosure;
import org.apache.ignite.internal.management.cache.FindAndDeleteGarbageInPersistenceJobResult;
import org.apache.ignite.internal.management.cache.FindAndDeleteGarbageInPersistenceTaskResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class FindAndDeleteGarbageInPersistenceTask
extends VisorMultiNodeTask<CacheFindGarbageCommandArg, FindAndDeleteGarbageInPersistenceTaskResult, FindAndDeleteGarbageInPersistenceJobResult> {
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    protected FindAndDeleteGarbageInPersistenceTaskResult reduce0(List<ComputeJobResult> list) throws IgniteException {
        HashMap<UUID, Exception> exceptions = new HashMap<UUID, Exception>();
        HashMap<UUID, FindAndDeleteGarbageInPersistenceJobResult> jobResults = new HashMap<UUID, FindAndDeleteGarbageInPersistenceJobResult>();
        for (ComputeJobResult res : list) {
            if (res.getException() != null) {
                exceptions.put(res.getNode().id(), res.getException());
                continue;
            }
            jobResults.put(res.getNode().id(), (FindAndDeleteGarbageInPersistenceJobResult)res.getData());
        }
        return new FindAndDeleteGarbageInPersistenceTaskResult(jobResults, exceptions);
    }

    @Override
    protected VisorJob<CacheFindGarbageCommandArg, FindAndDeleteGarbageInPersistenceJobResult> job(CacheFindGarbageCommandArg arg) {
        return new FindAndDeleteGarbageInPersistenceJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<CacheFindGarbageCommandArg> arg) {
        HashSet<UUID> nodeIds;
        Collection<ClusterNode> srvNodes = this.ignite.cluster().forServers().nodes();
        ArrayList<UUID> ret = new ArrayList<UUID>(srvNodes.size());
        HashSet<UUID> hashSet = nodeIds = arg.getArgument().nodeIds() == null ? null : new HashSet<UUID>(Arrays.asList(arg.getArgument().nodeIds()));
        if (nodeIds == null) {
            for (ClusterNode node : srvNodes) {
                ret.add(node.id());
            }
        } else {
            for (ClusterNode node : srvNodes) {
                if (!nodeIds.contains(node.id())) continue;
                ret.add(node.id());
            }
        }
        return ret;
    }

    private static class FindAndDeleteGarbageInPersistenceJob
    extends VisorJob<CacheFindGarbageCommandArg, FindAndDeleteGarbageInPersistenceJobResult> {
        private static final long serialVersionUID = 0L;

        protected FindAndDeleteGarbageInPersistenceJob(CacheFindGarbageCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected FindAndDeleteGarbageInPersistenceJobResult run(CacheFindGarbageCommandArg arg) throws IgniteException {
            try {
                FindAndDeleteGarbageInPersistenceClosure closure = new FindAndDeleteGarbageInPersistenceClosure(arg.groups(), arg.delete());
                this.ignite.context().resource().injectGeneric(closure);
                return closure.call();
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        public String toString() {
            return S.toString(FindAndDeleteGarbageInPersistenceJob.class, this);
        }
    }
}

