/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.metric;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.management.metric.MetricCommandArg;
import org.apache.ignite.internal.management.metric.MetricConfigureHistogramCommandArg;
import org.apache.ignite.internal.management.metric.MetricConfigureHitrateCommandArg;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.spi.metric.BooleanMetric;
import org.apache.ignite.spi.metric.DoubleMetric;
import org.apache.ignite.spi.metric.HistogramMetric;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.ObjectMetric;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.apache.ignite.spi.metric.jmx.MetricRegistryMBean;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class MetricTask
extends VisorOneNodeTask<MetricCommandArg, Map<String, ?>> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<MetricCommandArg, Map<String, ?>> job(MetricCommandArg arg) {
        return new MetricJob(arg, false);
    }

    private static class MetricJob
    extends VisorJob<MetricCommandArg, Map<String, ?>> {
        private static final long serialVersionUID = 0L;

        protected MetricJob(@Nullable MetricCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Map<String, ?> run(@Nullable MetricCommandArg arg) throws IgniteException {
            String name = arg.name();
            GridMetricManager mmgr = this.ignite.context().metric();
            try {
                if (arg instanceof MetricConfigureHistogramCommandArg) {
                    mmgr.configureHistogram(arg.name(), ((MetricConfigureHistogramCommandArg)arg).newBounds());
                    return null;
                }
                if (arg instanceof MetricConfigureHitrateCommandArg) {
                    mmgr.configureHitRate(arg.name(), ((MetricConfigureHitrateCommandArg)arg).newRateTimeInterval());
                    return null;
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            for (ReadOnlyMetricRegistry mreg : mmgr) {
                String mregName = mreg.name();
                if (mregName.equals(name)) {
                    LinkedHashMap res = new LinkedHashMap();
                    mreg.forEach(metric -> res.putAll(this.exportMetric((Metric)metric)));
                    return res;
                }
                String mregPrefix = mregName + ".";
                if (!name.startsWith(mregPrefix)) continue;
                if (mregPrefix.length() == name.length()) {
                    return null;
                }
                String metricName = name.substring(mregPrefix.length());
                Object metric2 = mreg.findMetric(metricName);
                if (metric2 != null) {
                    return this.exportMetric((Metric)metric2);
                }
                Long val = MetricRegistryMBean.searchHistogram(metricName, mreg);
                if (val == null) continue;
                return Collections.singletonMap(name, val);
            }
            return null;
        }

        private Object valueOf(Metric metric) {
            if (metric instanceof BooleanMetric) {
                return ((BooleanMetric)metric).value();
            }
            if (metric instanceof DoubleMetric) {
                return ((DoubleMetric)metric).value();
            }
            if (metric instanceof IntMetric) {
                return ((IntMetric)metric).value();
            }
            if (metric instanceof LongMetric) {
                return ((LongMetric)metric).value();
            }
            if (metric instanceof ObjectMetric) {
                return metric.getAsString();
            }
            throw new IllegalArgumentException("Unknown metric class [class=" + metric.getClass() + "]");
        }

        private Map<String, Object> exportMetric(Metric metric) {
            if (metric instanceof HistogramMetric) {
                HistogramMetric hist = (HistogramMetric)metric;
                String[] names = MetricUtils.histogramBucketNames(hist);
                LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
                for (int i = 0; i < names.length; ++i) {
                    res.put(names[i], ((long[])hist.value())[i]);
                }
                res.put(metric.name(), this.valueOf(metric));
                return res;
            }
            return Collections.singletonMap(metric.name(), this.valueOf(metric));
        }
    }
}

