/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tx;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.CliSubcommandsWithPrefix;
import org.apache.ignite.internal.management.api.CommandRegistryImpl;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.tx.TxCommandArg;
import org.apache.ignite.internal.management.tx.TxInfo;
import org.apache.ignite.internal.management.tx.TxInfoCommand;
import org.apache.ignite.internal.management.tx.TxTask;
import org.apache.ignite.internal.management.tx.TxTaskResult;

@CliSubcommandsWithPrefix
public class TxCommand
extends CommandRegistryImpl<AbstractTxCommandArg, Map<ClusterNode, TxTaskResult>>
implements ComputeCommand<AbstractTxCommandArg, Map<ClusterNode, TxTaskResult>> {
    public TxCommand() {
        super(new TxInfoCommand());
    }

    @Override
    public String description() {
        return "List or kill transactions";
    }

    @Override
    public Class<TxCommandArg> argClass() {
        return TxCommandArg.class;
    }

    @Override
    public Class<TxTask> taskClass() {
        return TxTask.class;
    }

    @Override
    public void printResult(AbstractTxCommandArg arg0, Map<ClusterNode, TxTaskResult> res, Consumer<String> printer) {
        TxCommandArg arg = (TxCommandArg)arg0;
        if (res.isEmpty()) {
            printer.accept("Nothing found.");
        } else if (arg.kill()) {
            printer.accept("Killed transactions:");
        } else {
            printer.accept("Matching transactions:");
        }
        for (Map.Entry<ClusterNode, TxTaskResult> entry : res.entrySet()) {
            if (entry.getValue().getInfos().isEmpty()) continue;
            printer.accept(TxCommand.nodeDescription(entry.getKey()));
            for (TxInfo info : entry.getValue().getInfos()) {
                printer.accept(info.toUserString());
            }
        }
    }

    @Override
    public String confirmationPrompt(AbstractTxCommandArg arg) {
        if (((TxCommandArg)arg).kill()) {
            return "Warning: the command will kill some transactions.";
        }
        return null;
    }

    static String nodeDescription(ClusterNode node) {
        return node.getClass().getSimpleName() + " [id=" + node.id() + ", addrs=" + node.addresses() + ", order=" + node.order() + ", ver=" + node.version() + ", isClient=" + node.isClient() + ", consistentId=" + node.consistentId() + "]";
    }

    public static abstract class AbstractTxCommandArg
    extends IgniteDataTransferObject {
    }
}

