/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.managers.systemview.AbstractSystemView;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.jetbrains.annotations.NotNull;

public class SystemViewAdapter<R, D>
extends AbstractSystemView<R> {
    private Collection<D> data;
    private Supplier<Collection<D>> dataSupplier;
    private final Function<D, R> rowFunc;

    public SystemViewAdapter(String name, String desc, SystemViewRowAttributeWalker<R> walker, Collection<D> data, Function<D, R> rowFunc) {
        super(name, desc, walker);
        A.notNull(data, "data");
        this.data = data;
        this.rowFunc = rowFunc;
    }

    public SystemViewAdapter(String name, String desc, SystemViewRowAttributeWalker<R> walker, Supplier<Collection<D>> dataSupplier, Function<D, R> rowFunc) {
        super(name, desc, walker);
        A.notNull(dataSupplier, "dataSupplier");
        this.dataSupplier = dataSupplier;
        this.rowFunc = rowFunc;
    }

    @Override
    @NotNull
    public Iterator<R> iterator() {
        final Iterator<D> dataIter = this.data != null ? this.data.iterator() : this.dataSupplier.get().iterator();
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return dataIter.hasNext();
            }

            @Override
            public R next() {
                return SystemViewAdapter.this.rowFunc.apply(dataIter.next());
            }
        };
    }

    @Override
    public int size() {
        return this.data == null ? this.dataSupplier.get().size() : this.data.size();
    }
}

