/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerType;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotWarningException;
import org.apache.ignite.plugin.Extension;
import org.jetbrains.annotations.Nullable;

public interface SnapshotHandler<T>
extends Extension {
    public SnapshotHandlerType type();

    @Nullable
    public T invoke(SnapshotHandlerContext var1) throws Exception;

    default public void complete(String name, Collection<SnapshotHandlerResult<T>> results) throws SnapshotWarningException, Exception {
        for (SnapshotHandlerResult<T> res : results) {
            if (res.error() == null) continue;
            throw new IgniteCheckedException("Snapshot handler has failed. " + res.error().getMessage() + " [snapshot=" + name + ", handler=" + this.getClass().getName() + ", nodeId=" + res.node().id() + "].", res.error());
        }
    }
}

