/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security.sandbox;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.security.sandbox.IgniteDomainCombiner;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;
import org.apache.ignite.plugin.security.SecurityException;

public class AccessControllerSandbox
implements IgniteSandbox {
    private final IgniteSecurity security;
    private final IgniteLogger log;

    public AccessControllerSandbox(GridKernalContext ctx, IgniteSecurity security) {
        this.security = security;
        this.log = ctx.log(this.getClass());
    }

    @Override
    public <T> T execute(Callable<T> c) throws IgniteException {
        Objects.requireNonNull(c);
        if (!SecurityUtils.hasSecurityManager()) {
            throw new SecurityException("SecurityManager was, but it disappeared!");
        }
        SecurityContext secCtx = this.security.securityContext();
        assert (secCtx != null);
        AccessControlContext acc = AccessController.doPrivileged(() -> new AccessControlContext(AccessController.getContext(), new IgniteDomainCombiner(secCtx.subject().sandboxPermissions())));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing the action inside the sandbox [subjId=" + secCtx.subject().id() + "]");
        }
        try {
            return (T)AccessController.doPrivileged(c::call, acc);
        }
        catch (PrivilegedActionException e) {
            throw new IgniteException(e.getException());
        }
    }

    @Override
    public boolean enabled() {
        return true;
    }
}

