/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.IgniteSpiTimeoutObject;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionKey;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationNodeConnectionCheckFuture;
import org.jetbrains.annotations.Nullable;

public class TcpCommunicationConnectionCheckFuture
extends GridFutureAdapter<BitSet>
implements IgniteSpiTimeoutObject,
GridLocalEventListener {
    public static final int SES_FUT_META = GridNioSessionMetaKey.nextUniqueKey();
    private static final AtomicIntegerFieldUpdater<SingleAddressConnectFuture> connFutDoneUpdater = AtomicIntegerFieldUpdater.newUpdater(SingleAddressConnectFuture.class, "done");
    private static final AtomicIntegerFieldUpdater<MultipleAddressesConnectFuture> connResCntUpdater = AtomicIntegerFieldUpdater.newUpdater(MultipleAddressesConnectFuture.class, "resCnt");
    private final AtomicInteger resCntr = new AtomicInteger();
    private final List<ClusterNode> nodes;
    private volatile ConnectFuture[] futs;
    private final GridNioServer nioSrvr;
    private final TcpCommunicationSpi spi;
    private final IgniteUuid timeoutObjId = IgniteUuid.randomUuid();
    private final BitSet resBitSet;
    private long endTime;
    private final IgniteLogger log;

    public TcpCommunicationConnectionCheckFuture(TcpCommunicationSpi spi, IgniteLogger log, GridNioServer nioSrvr, List<ClusterNode> nodes) {
        this.spi = spi;
        this.log = log;
        this.nioSrvr = nioSrvr;
        this.nodes = nodes;
        this.resBitSet = new BitSet(nodes.size());
    }

    public void init(long timeout) {
        ConnectFuture[] futs = new ConnectFuture[this.nodes.size()];
        UUID locId = this.spi.getSpiContext().localNode().id();
        for (int i = 0; i < this.nodes.size(); ++i) {
            ClusterNode node = this.nodes.get(i);
            if (!node.id().equals(locId)) {
                ConnectFuture fut;
                Collection<InetSocketAddress> addrs;
                if (this.spi.getSpiContext().node(node.id()) == null) {
                    this.receivedConnectionStatus(i, false);
                    continue;
                }
                try {
                    addrs = this.spi.nodeAddresses(node, false);
                }
                catch (Exception e) {
                    U.error(this.log, "Failed to get node addresses: " + node, e);
                    this.receivedConnectionStatus(i, false);
                    continue;
                }
                if (addrs.size() == 1) {
                    fut = new SingleAddressConnectFuture(i);
                    ((SingleAddressConnectFuture)fut).init(addrs.iterator().next(), node.consistentId(), node.id());
                    futs[i] = fut;
                    continue;
                }
                fut = new MultipleAddressesConnectFuture(i);
                ((MultipleAddressesConnectFuture)fut).init(addrs, node.consistentId(), node.id());
                futs[i] = fut;
                continue;
            }
            this.receivedConnectionStatus(i, true);
        }
        this.futs = futs;
        this.spi.getSpiContext().addLocalEventListener(this, 11, 12);
        if (!this.isDone()) {
            this.endTime = System.currentTimeMillis() + timeout;
            this.spi.getSpiContext().addTimeoutObject(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedConnectionStatus(int idx, boolean res) {
        assert (this.resCntr.get() < this.nodes.size());
        BitSet bitSet = this.resBitSet;
        synchronized (bitSet) {
            this.resBitSet.set(idx, res);
        }
        if (this.resCntr.incrementAndGet() == this.nodes.size()) {
            this.onDone(this.resBitSet);
        }
    }

    private UUID nodeId(int nodeIdx) {
        return this.nodes.get(nodeIdx).id();
    }

    @Override
    public IgniteUuid id() {
        return this.timeoutObjId;
    }

    @Override
    public long endTime() {
        return this.endTime;
    }

    @Override
    public void onEvent(Event evt) {
        if (this.isDone()) {
            return;
        }
        assert (evt instanceof DiscoveryEvent) : evt;
        assert (evt.type() == 11 || evt.type() == 12);
        UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).id().equals(nodeId)) continue;
            ConnectFuture fut = this.futs[i];
            if (fut != null) {
                fut.onNodeFailed();
            }
            return;
        }
    }

    @Override
    public void onTimeout() {
        if (this.isDone()) {
            return;
        }
        ConnectFuture[] futs = this.futs;
        for (int i = 0; i < futs.length; ++i) {
            ConnectFuture fut = futs[i];
            if (fut == null) continue;
            fut.onTimeout();
        }
    }

    @Override
    public boolean onDone(@Nullable BitSet res, @Nullable Throwable err) {
        if (super.onDone(res, err)) {
            this.spi.getSpiContext().removeTimeoutObject(this);
            this.spi.getSpiContext().removeLocalEventListener(this);
            return true;
        }
        return false;
    }

    private class MultipleAddressesConnectFuture
    implements ConnectFuture {
        volatile int resCnt;
        volatile SingleAddressConnectFuture[] futs;
        final int nodeIdx;

        MultipleAddressesConnectFuture(int nodeIdx) {
            this.nodeIdx = nodeIdx;
        }

        @Override
        public void onNodeFailed() {
            SingleAddressConnectFuture[] futs = this.futs;
            for (int i = 0; i < futs.length; ++i) {
                SingleAddressConnectFuture fut = futs[i];
                if (fut == null) continue;
                fut.onNodeFailed();
            }
        }

        @Override
        public void onTimeout() {
            SingleAddressConnectFuture[] futs = this.futs;
            for (int i = 0; i < futs.length; ++i) {
                SingleAddressConnectFuture fut = futs[i];
                if (fut == null) continue;
                fut.onTimeout();
            }
        }

        void init(Collection<InetSocketAddress> addrs, Object consistentId, UUID rmtNodeId) {
            SingleAddressConnectFuture[] futs = new SingleAddressConnectFuture[addrs.size()];
            for (int i = 0; i < addrs.size(); ++i) {
                SingleAddressConnectFuture fut;
                futs[i] = fut = new SingleAddressConnectFuture(this.nodeIdx){

                    @Override
                    void onStatusReceived(boolean res) {
                        MultipleAddressesConnectFuture.this.receivedAddressStatus(res);
                    }
                };
            }
            this.futs = futs;
            int idx = 0;
            for (InetSocketAddress addr : addrs) {
                futs[idx++].init(addr, consistentId, rmtNodeId);
                if (this.resCnt != Integer.MAX_VALUE) continue;
                return;
            }
            if (this.done()) {
                this.cancelFutures();
            }
        }

        private boolean done() {
            int resCnt0 = this.resCnt;
            return resCnt0 == Integer.MAX_VALUE || resCnt0 == this.futs.length;
        }

        private void cancelFutures() {
            SingleAddressConnectFuture[] futs = this.futs;
            if (futs != null) {
                for (int i = 0; i < futs.length; ++i) {
                    SingleAddressConnectFuture fut = futs[i];
                    fut.cancel();
                }
            }
        }

        void receivedAddressStatus(boolean res) {
            int resCnt1;
            int resCnt0;
            if (res) {
                int resCnt02;
                do {
                    if ((resCnt02 = this.resCnt) != Integer.MAX_VALUE) continue;
                    return;
                } while (!connResCntUpdater.compareAndSet(this, resCnt02, Integer.MAX_VALUE));
                TcpCommunicationConnectionCheckFuture.this.receivedConnectionStatus(this.nodeIdx, true);
                this.cancelFutures();
                return;
            }
            do {
                if ((resCnt0 = this.resCnt) != Integer.MAX_VALUE) continue;
                return;
            } while (!connResCntUpdater.compareAndSet(this, resCnt0, resCnt1 = resCnt0 + 1));
            if (resCnt1 == this.futs.length) {
                TcpCommunicationConnectionCheckFuture.this.receivedConnectionStatus(this.nodeIdx, false);
            }
        }
    }

    private class SingleAddressConnectFuture
    implements TcpCommunicationNodeConnectionCheckFuture,
    ConnectFuture {
        final int nodeIdx;
        volatile int done;
        Map<Integer, Object> sesMeta;
        private SocketChannel ch;

        SingleAddressConnectFuture(int nodeIdx) {
            this.nodeIdx = nodeIdx;
        }

        public void init(InetSocketAddress addr, Object consistentId, UUID rmtNodeId) {
            boolean connect;
            try {
                this.ch = SocketChannel.open();
                this.ch.configureBlocking(false);
                this.ch.socket().setTcpNoDelay(true);
                this.ch.socket().setKeepAlive(false);
                connect = this.ch.connect(addr);
            }
            catch (Exception e) {
                this.finish(false);
                return;
            }
            if (!connect) {
                this.sesMeta = new GridLeanMap<Integer, Object>(3);
                ConnectionKey connKey = new ConnectionKey(rmtNodeId, -1, -1L, true);
                this.sesMeta.put(TcpCommunicationSpi.CONN_IDX_META, connKey);
                this.sesMeta.put(TcpCommunicationSpi.CONSISTENT_ID_META, consistentId);
                this.sesMeta.put(SES_FUT_META, this);
                TcpCommunicationConnectionCheckFuture.this.nioSrvr.createSession(this.ch, this.sesMeta, true, (IgniteInClosure<IgniteInternalFuture<GridNioSession>>)new IgniteInClosure<IgniteInternalFuture<GridNioSession>>(){

                    @Override
                    public void apply(IgniteInternalFuture<GridNioSession> fut) {
                        if (fut.error() != null) {
                            SingleAddressConnectFuture.this.finish(false);
                        }
                    }
                });
            }
        }

        void cancel() {
            if (this.finish(false)) {
                TcpCommunicationConnectionCheckFuture.this.nioSrvr.cancelConnect(this.ch, this.sesMeta);
            }
        }

        @Override
        public void onTimeout() {
            this.cancel();
        }

        @Override
        public void onConnected(UUID rmtNodeId) {
            this.finish(TcpCommunicationConnectionCheckFuture.this.nodeId(this.nodeIdx).equals(rmtNodeId));
        }

        @Override
        public void onNodeFailed() {
            this.cancel();
        }

        public boolean finish(boolean res) {
            if (connFutDoneUpdater.compareAndSet(this, 0, 1)) {
                this.onStatusReceived(res);
                return true;
            }
            return false;
        }

        void onStatusReceived(boolean res) {
            TcpCommunicationConnectionCheckFuture.this.receivedConnectionStatus(this.nodeIdx, res);
        }
    }

    private static interface ConnectFuture {
        public void onTimeout();

        public void onNodeFailed();
    }
}

