/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeHostsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHostsRequestMarshaller
implements Marshaller<Request<DescribeHostsRequest>, DescribeHostsRequest> {
    public Request<DescribeHostsRequest> marshall(DescribeHostsRequest describeHostsRequest) {
        SdkInternalList describeHostsRequestFilterList;
        if (describeHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeHostsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeHostsRequestHostIdsList = (SdkInternalList)describeHostsRequest.getHostIds();
        if (!describeHostsRequestHostIdsList.isEmpty() || !describeHostsRequestHostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String describeHostsRequestHostIdsListValue : describeHostsRequestHostIdsList) {
                if (describeHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString((String)describeHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        if (describeHostsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeHostsRequest.getNextToken()));
        }
        if (describeHostsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeHostsRequest.getMaxResults()));
        }
        if (!(describeHostsRequestFilterList = (SdkInternalList)describeHostsRequest.getFilter()).isEmpty() || !describeHostsRequestFilterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter describeHostsRequestFilterListValue : describeHostsRequestFilterList) {
                SdkInternalList filterValuesList;
                if (describeHostsRequestFilterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)describeHostsRequestFilterListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeHostsRequestFilterListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        return request;
    }
}

