/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public class ExponentialBackoff
implements RetryStrategy {
    private static final double JITTER_FACTOR = 0.05;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final Duration DEFAULT_BASE_DELAY = Duration.ofMillis(800L);
    private static final Duration DEFAULT_MAX_DELAY = Duration.ofSeconds(8L);
    private final ClientLogger logger = new ClientLogger(ExponentialBackoff.class);
    private final int maxRetries;
    private final Duration baseDelay;
    private final Duration maxDelay;

    public ExponentialBackoff() {
        this(3, DEFAULT_BASE_DELAY, DEFAULT_MAX_DELAY);
    }

    public ExponentialBackoff(int maxRetries, Duration baseDelay, Duration maxDelay) {
        if (maxRetries < 0) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Max retries cannot be less than 0."));
        }
        Objects.requireNonNull(baseDelay, "'baseDelay' cannot be null.");
        Objects.requireNonNull(maxDelay, "'maxDelay' cannot be null.");
        if (baseDelay.isZero()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be 0."));
        }
        if (baseDelay.compareTo(maxDelay) > 0) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be greater than 'maxDelay'."));
        }
        this.maxRetries = maxRetries;
        this.baseDelay = baseDelay;
        this.maxDelay = maxDelay;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public Duration calculateRetryDelay(int retryAttempts) {
        long delayWithJitterInNanos = ThreadLocalRandom.current().nextLong((long)((double)this.baseDelay.toNanos() * 0.95), (long)((double)this.baseDelay.toNanos() * 1.05));
        Duration delay = Duration.ofNanos(Math.min((long)(1 << retryAttempts) * delayWithJitterInNanos, this.maxDelay.toNanos()));
        return delay;
    }
}

