/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.optaplanner.core.config.heuristic.selector.move.generic;

import static org.assertj.core.api.SoftAssertions.assertSoftly;

import org.junit.jupiter.api.Test;
import org.optaplanner.core.config.heuristic.selector.entity.pillar.PillarSelectorConfig;

class PillarSwapMoveSelectorConfigTest {

    @Test
    void withMethodCallsProperlyChain() {
        final int minimumSubPillarSize = 5;
        final double fixedProbabilityWeight = 1.0;
        final int maximumSubPillarSize = 10;
        PillarSwapMoveSelectorConfig pillarSwapMoveSelectorConfig = new PillarSwapMoveSelectorConfig()
                .withPillarSelectorConfig(new PillarSelectorConfig().withMinimumSubPillarSize(minimumSubPillarSize))
                .withFixedProbabilityWeight(fixedProbabilityWeight)
                .withSecondaryPillarSelectorConfig(
                        new PillarSelectorConfig().withMaximumSubPillarSize(maximumSubPillarSize));

        assertSoftly(softly -> {
            softly.assertThat(pillarSwapMoveSelectorConfig.getFixedProbabilityWeight()).isEqualTo(fixedProbabilityWeight);
            softly.assertThat(pillarSwapMoveSelectorConfig.getPillarSelectorConfig()).isNotNull();
            softly.assertThat(pillarSwapMoveSelectorConfig.getPillarSelectorConfig().getMinimumSubPillarSize())
                    .isEqualTo(minimumSubPillarSize);
            softly.assertThat(pillarSwapMoveSelectorConfig.getSecondaryPillarSelectorConfig()).isNotNull();
            softly.assertThat(pillarSwapMoveSelectorConfig.getSecondaryPillarSelectorConfig().getMaximumSubPillarSize())
                    .isEqualTo(maximumSubPillarSize);
        });
    }
}
