/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

export class ReservedWords {
  public static readonly FeelKeywords: ReadonlySet<string> = new Set<string>([
    "and",
    "between",
    "else",
    "every",
    "external",
    "false",
    "for",
    "function",
    "if",
    "in",
    "instance of",
    "not",
    "null",
    "or",
    "return",
    "then",
    "satisfies",
    "some",
    "true",
  ]);

  public static readonly FeelFunctions: ReadonlySet<string> = new Set<string>([
    "abs",
    "after",
    "all",
    "any",
    "append",
    "before",
    "ceiling",
    "code",
    "coincides",
    "concatenate",
    "contains",
    "context",
    "context put",
    "context merge",
    "count",
    "date",
    "date and time",
    "day of week",
    "day of year",
    "decimal",
    "decision table",
    "distinct values",
    "duration",
    "during",
    "ends with",
    "even",
    "exp",
    "finished by",
    "finishes",
    "flatten",
    "floor",
    "get entries",
    "get value",
    "includes",
    "index of",
    "insert before",
    "invoke",
    "is",
    "list contains",
    "list replace",
    "log",
    "lower case",
    "matches",
    "max",
    "mean",
    "median",
    "meets",
    "met by",
    "min",
    "mode",
    "modulo",
    "month of year",
    "nn all",
    "nn any",
    "nn count",
    "nn max",
    "nn mean",
    "nn median",
    "nn min",
    "nn mode",
    "nn stddev",
    "nn sum",
    "not",
    "now",
    "number",
    "odd",
    "overlaps after",
    "overlaps before",
    "overlaps",
    "product",
    "range",
    "remove",
    "replace",
    "reverse",
    "round down",
    "round half down",
    "round half up",
    "round up",
    "sort",
    "split",
    "sqrt",
    "started by",
    "starts with",
    "starts",
    "stddev",
    "string",
    "string join",
    "string length",
    "sublist",
    "substring after",
    "substring before",
    "substring",
    "sum",
    "time",
    "today",
    "union",
    "upper case",
    "week of year",
    "years and months duration",
  ]);
}
