// Autogenerated by Thrift Compiler (0.13.0)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

package radmin

import (
	"bytes"
	"context"
	"fmt"
	"github.com/apache/incubator-pegasus/go-client/idl/base"
	"github.com/apache/thrift/lib/go/thrift"
	"reflect"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = context.Background
var _ = reflect.DeepEqual
var _ = bytes.Equal

var _ = base.GoUnusedProtection__

// Attributes:
//  - Tag
//  - FullDir
//  - DiskCapacityMb
//  - DiskAvailableMb
//  - HoldingPrimaryReplicas
//  - HoldingSecondaryReplicas
type DiskInfo struct {
	Tag                      string                 `thrift:"tag,1" db:"tag" json:"tag"`
	FullDir                  string                 `thrift:"full_dir,2" db:"full_dir" json:"full_dir"`
	DiskCapacityMb           int64                  `thrift:"disk_capacity_mb,3" db:"disk_capacity_mb" json:"disk_capacity_mb"`
	DiskAvailableMb          int64                  `thrift:"disk_available_mb,4" db:"disk_available_mb" json:"disk_available_mb"`
	HoldingPrimaryReplicas   map[int32][]*base.Gpid `thrift:"holding_primary_replicas,5" db:"holding_primary_replicas" json:"holding_primary_replicas"`
	HoldingSecondaryReplicas map[int32][]*base.Gpid `thrift:"holding_secondary_replicas,6" db:"holding_secondary_replicas" json:"holding_secondary_replicas"`
}

func NewDiskInfo() *DiskInfo {
	return &DiskInfo{}
}

func (p *DiskInfo) GetTag() string {
	return p.Tag
}

func (p *DiskInfo) GetFullDir() string {
	return p.FullDir
}

func (p *DiskInfo) GetDiskCapacityMb() int64 {
	return p.DiskCapacityMb
}

func (p *DiskInfo) GetDiskAvailableMb() int64 {
	return p.DiskAvailableMb
}

func (p *DiskInfo) GetHoldingPrimaryReplicas() map[int32][]*base.Gpid {
	return p.HoldingPrimaryReplicas
}

func (p *DiskInfo) GetHoldingSecondaryReplicas() map[int32][]*base.Gpid {
	return p.HoldingSecondaryReplicas
}
func (p *DiskInfo) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField4(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField5(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField6(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *DiskInfo) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Tag = v
	}
	return nil
}

func (p *DiskInfo) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.FullDir = v
	}
	return nil
}

func (p *DiskInfo) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.DiskCapacityMb = v
	}
	return nil
}

func (p *DiskInfo) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.DiskAvailableMb = v
	}
	return nil
}

func (p *DiskInfo) ReadField5(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(map[int32][]*base.Gpid, size)
	p.HoldingPrimaryReplicas = tMap
	for i := 0; i < size; i++ {
		var _key0 int32
		if v, err := iprot.ReadI32(); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key0 = v
		}
		_, size, err := iprot.ReadSetBegin()
		if err != nil {
			return thrift.PrependError("error reading set begin: ", err)
		}
		tSet := make([]*base.Gpid, 0, size)
		_val1 := tSet
		for i := 0; i < size; i++ {
			_elem2 := &base.Gpid{}
			if err := _elem2.Read(iprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem2), err)
			}
			_val1 = append(_val1, _elem2)
		}
		if err := iprot.ReadSetEnd(); err != nil {
			return thrift.PrependError("error reading set end: ", err)
		}
		p.HoldingPrimaryReplicas[_key0] = _val1
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *DiskInfo) ReadField6(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(map[int32][]*base.Gpid, size)
	p.HoldingSecondaryReplicas = tMap
	for i := 0; i < size; i++ {
		var _key3 int32
		if v, err := iprot.ReadI32(); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key3 = v
		}
		_, size, err := iprot.ReadSetBegin()
		if err != nil {
			return thrift.PrependError("error reading set begin: ", err)
		}
		tSet := make([]*base.Gpid, 0, size)
		_val4 := tSet
		for i := 0; i < size; i++ {
			_elem5 := &base.Gpid{}
			if err := _elem5.Read(iprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem5), err)
			}
			_val4 = append(_val4, _elem5)
		}
		if err := iprot.ReadSetEnd(); err != nil {
			return thrift.PrependError("error reading set end: ", err)
		}
		p.HoldingSecondaryReplicas[_key3] = _val4
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *DiskInfo) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("disk_info"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
		if err := p.writeField6(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *DiskInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("tag", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:tag: ", p), err)
	}
	if err := oprot.WriteString(string(p.Tag)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.tag (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:tag: ", p), err)
	}
	return err
}

func (p *DiskInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("full_dir", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:full_dir: ", p), err)
	}
	if err := oprot.WriteString(string(p.FullDir)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.full_dir (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:full_dir: ", p), err)
	}
	return err
}

func (p *DiskInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("disk_capacity_mb", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:disk_capacity_mb: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.DiskCapacityMb)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.disk_capacity_mb (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:disk_capacity_mb: ", p), err)
	}
	return err
}

func (p *DiskInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("disk_available_mb", thrift.I64, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:disk_available_mb: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.DiskAvailableMb)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.disk_available_mb (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:disk_available_mb: ", p), err)
	}
	return err
}

func (p *DiskInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("holding_primary_replicas", thrift.MAP, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:holding_primary_replicas: ", p), err)
	}
	if err := oprot.WriteMapBegin(thrift.I32, thrift.SET, len(p.HoldingPrimaryReplicas)); err != nil {
		return thrift.PrependError("error writing map begin: ", err)
	}
	for k, v := range p.HoldingPrimaryReplicas {
		if err := oprot.WriteI32(int32(k)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
		if err := oprot.WriteSetBegin(thrift.STRUCT, len(v)); err != nil {
			return thrift.PrependError("error writing set begin: ", err)
		}
		for i := 0; i < len(v); i++ {
			for j := i + 1; j < len(v); j++ {
				if reflect.DeepEqual(v[i], v[j]) {
					return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", v[i]))
				}
			}
		}
		for _, v := range v {
			if err := v.Write(oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteSetEnd(); err != nil {
			return thrift.PrependError("error writing set end: ", err)
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return thrift.PrependError("error writing map end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:holding_primary_replicas: ", p), err)
	}
	return err
}

func (p *DiskInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("holding_secondary_replicas", thrift.MAP, 6); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:holding_secondary_replicas: ", p), err)
	}
	if err := oprot.WriteMapBegin(thrift.I32, thrift.SET, len(p.HoldingSecondaryReplicas)); err != nil {
		return thrift.PrependError("error writing map begin: ", err)
	}
	for k, v := range p.HoldingSecondaryReplicas {
		if err := oprot.WriteI32(int32(k)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
		if err := oprot.WriteSetBegin(thrift.STRUCT, len(v)); err != nil {
			return thrift.PrependError("error writing set begin: ", err)
		}
		for i := 0; i < len(v); i++ {
			for j := i + 1; j < len(v); j++ {
				if reflect.DeepEqual(v[i], v[j]) {
					return thrift.PrependError("", fmt.Errorf("%T error writing set field: slice is not unique", v[i]))
				}
			}
		}
		for _, v := range v {
			if err := v.Write(oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteSetEnd(); err != nil {
			return thrift.PrependError("error writing set end: ", err)
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return thrift.PrependError("error writing map end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 6:holding_secondary_replicas: ", p), err)
	}
	return err
}

func (p *DiskInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DiskInfo(%+v)", *p)
}

// Attributes:
//  - Node
//  - AppName
type QueryDiskInfoRequest struct {
	Node    *base.RPCAddress `thrift:"node,1" db:"node" json:"node"`
	AppName string           `thrift:"app_name,2" db:"app_name" json:"app_name"`
}

func NewQueryDiskInfoRequest() *QueryDiskInfoRequest {
	return &QueryDiskInfoRequest{}
}

var QueryDiskInfoRequest_Node_DEFAULT *base.RPCAddress

func (p *QueryDiskInfoRequest) GetNode() *base.RPCAddress {
	if !p.IsSetNode() {
		return QueryDiskInfoRequest_Node_DEFAULT
	}
	return p.Node
}

func (p *QueryDiskInfoRequest) GetAppName() string {
	return p.AppName
}
func (p *QueryDiskInfoRequest) IsSetNode() bool {
	return p.Node != nil
}

func (p *QueryDiskInfoRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *QueryDiskInfoRequest) ReadField1(iprot thrift.TProtocol) error {
	p.Node = &base.RPCAddress{}
	if err := p.Node.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Node), err)
	}
	return nil
}

func (p *QueryDiskInfoRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.AppName = v
	}
	return nil
}

func (p *QueryDiskInfoRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("query_disk_info_request"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *QueryDiskInfoRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("node", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:node: ", p), err)
	}
	if err := p.Node.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Node), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:node: ", p), err)
	}
	return err
}

func (p *QueryDiskInfoRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("app_name", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:app_name: ", p), err)
	}
	if err := oprot.WriteString(string(p.AppName)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.app_name (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:app_name: ", p), err)
	}
	return err
}

func (p *QueryDiskInfoRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("QueryDiskInfoRequest(%+v)", *p)
}

// Attributes:
//  - Err
//  - TotalCapacityMb
//  - TotalAvailableMb
//  - DiskInfos
type QueryDiskInfoResponse struct {
	Err              *base.ErrorCode `thrift:"err,1" db:"err" json:"err"`
	TotalCapacityMb  int64           `thrift:"total_capacity_mb,2" db:"total_capacity_mb" json:"total_capacity_mb"`
	TotalAvailableMb int64           `thrift:"total_available_mb,3" db:"total_available_mb" json:"total_available_mb"`
	DiskInfos        []*DiskInfo     `thrift:"disk_infos,4" db:"disk_infos" json:"disk_infos"`
}

func NewQueryDiskInfoResponse() *QueryDiskInfoResponse {
	return &QueryDiskInfoResponse{}
}

var QueryDiskInfoResponse_Err_DEFAULT *base.ErrorCode

func (p *QueryDiskInfoResponse) GetErr() *base.ErrorCode {
	if !p.IsSetErr() {
		return QueryDiskInfoResponse_Err_DEFAULT
	}
	return p.Err
}

func (p *QueryDiskInfoResponse) GetTotalCapacityMb() int64 {
	return p.TotalCapacityMb
}

func (p *QueryDiskInfoResponse) GetTotalAvailableMb() int64 {
	return p.TotalAvailableMb
}

func (p *QueryDiskInfoResponse) GetDiskInfos() []*DiskInfo {
	return p.DiskInfos
}
func (p *QueryDiskInfoResponse) IsSetErr() bool {
	return p.Err != nil
}

func (p *QueryDiskInfoResponse) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField2(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField4(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *QueryDiskInfoResponse) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &base.ErrorCode{}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *QueryDiskInfoResponse) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.TotalCapacityMb = v
	}
	return nil
}

func (p *QueryDiskInfoResponse) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.TotalAvailableMb = v
	}
	return nil
}

func (p *QueryDiskInfoResponse) ReadField4(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*DiskInfo, 0, size)
	p.DiskInfos = tSlice
	for i := 0; i < size; i++ {
		_elem6 := &DiskInfo{}
		if err := _elem6.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem6), err)
		}
		p.DiskInfos = append(p.DiskInfos, _elem6)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *QueryDiskInfoResponse) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("query_disk_info_response"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *QueryDiskInfoResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
	}
	if err := p.Err.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
	}
	return err
}

func (p *QueryDiskInfoResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("total_capacity_mb", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:total_capacity_mb: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.TotalCapacityMb)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.total_capacity_mb (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:total_capacity_mb: ", p), err)
	}
	return err
}

func (p *QueryDiskInfoResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("total_available_mb", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:total_available_mb: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.TotalAvailableMb)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.total_available_mb (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:total_available_mb: ", p), err)
	}
	return err
}

func (p *QueryDiskInfoResponse) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("disk_infos", thrift.LIST, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:disk_infos: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.DiskInfos)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.DiskInfos {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:disk_infos: ", p), err)
	}
	return err
}

func (p *QueryDiskInfoResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("QueryDiskInfoResponse(%+v)", *p)
}

// Attributes:
//  - Pid
//  - OriginDisk
//  - TargetDisk
type ReplicaDiskMigrateRequest struct {
	Pid        *base.Gpid `thrift:"pid,1" db:"pid" json:"pid"`
	OriginDisk string     `thrift:"origin_disk,2" db:"origin_disk" json:"origin_disk"`
	TargetDisk string     `thrift:"target_disk,3" db:"target_disk" json:"target_disk"`
}

func NewReplicaDiskMigrateRequest() *ReplicaDiskMigrateRequest {
	return &ReplicaDiskMigrateRequest{}
}

var ReplicaDiskMigrateRequest_Pid_DEFAULT *base.Gpid

func (p *ReplicaDiskMigrateRequest) GetPid() *base.Gpid {
	if !p.IsSetPid() {
		return ReplicaDiskMigrateRequest_Pid_DEFAULT
	}
	return p.Pid
}

func (p *ReplicaDiskMigrateRequest) GetOriginDisk() string {
	return p.OriginDisk
}

func (p *ReplicaDiskMigrateRequest) GetTargetDisk() string {
	return p.TargetDisk
}
func (p *ReplicaDiskMigrateRequest) IsSetPid() bool {
	return p.Pid != nil
}

func (p *ReplicaDiskMigrateRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField3(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ReplicaDiskMigrateRequest) ReadField1(iprot thrift.TProtocol) error {
	p.Pid = &base.Gpid{}
	if err := p.Pid.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Pid), err)
	}
	return nil
}

func (p *ReplicaDiskMigrateRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.OriginDisk = v
	}
	return nil
}

func (p *ReplicaDiskMigrateRequest) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.TargetDisk = v
	}
	return nil
}

func (p *ReplicaDiskMigrateRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("replica_disk_migrate_request"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ReplicaDiskMigrateRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("pid", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:pid: ", p), err)
	}
	if err := p.Pid.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Pid), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:pid: ", p), err)
	}
	return err
}

func (p *ReplicaDiskMigrateRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("origin_disk", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:origin_disk: ", p), err)
	}
	if err := oprot.WriteString(string(p.OriginDisk)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.origin_disk (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:origin_disk: ", p), err)
	}
	return err
}

func (p *ReplicaDiskMigrateRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("target_disk", thrift.STRING, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:target_disk: ", p), err)
	}
	if err := oprot.WriteString(string(p.TargetDisk)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.target_disk (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:target_disk: ", p), err)
	}
	return err
}

func (p *ReplicaDiskMigrateRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReplicaDiskMigrateRequest(%+v)", *p)
}

// Attributes:
//  - Err
//  - Hint
type ReplicaDiskMigrateResponse struct {
	Err  *base.ErrorCode `thrift:"err,1" db:"err" json:"err"`
	Hint *string         `thrift:"hint,2" db:"hint" json:"hint,omitempty"`
}

func NewReplicaDiskMigrateResponse() *ReplicaDiskMigrateResponse {
	return &ReplicaDiskMigrateResponse{}
}

var ReplicaDiskMigrateResponse_Err_DEFAULT *base.ErrorCode

func (p *ReplicaDiskMigrateResponse) GetErr() *base.ErrorCode {
	if !p.IsSetErr() {
		return ReplicaDiskMigrateResponse_Err_DEFAULT
	}
	return p.Err
}

var ReplicaDiskMigrateResponse_Hint_DEFAULT string

func (p *ReplicaDiskMigrateResponse) GetHint() string {
	if !p.IsSetHint() {
		return ReplicaDiskMigrateResponse_Hint_DEFAULT
	}
	return *p.Hint
}
func (p *ReplicaDiskMigrateResponse) IsSetErr() bool {
	return p.Err != nil
}

func (p *ReplicaDiskMigrateResponse) IsSetHint() bool {
	return p.Hint != nil
}

func (p *ReplicaDiskMigrateResponse) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ReplicaDiskMigrateResponse) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &base.ErrorCode{}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *ReplicaDiskMigrateResponse) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Hint = &v
	}
	return nil
}

func (p *ReplicaDiskMigrateResponse) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("replica_disk_migrate_response"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ReplicaDiskMigrateResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
	}
	if err := p.Err.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
	}
	return err
}

func (p *ReplicaDiskMigrateResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetHint() {
		if err := oprot.WriteFieldBegin("hint", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:hint: ", p), err)
		}
		if err := oprot.WriteString(string(*p.Hint)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.hint (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:hint: ", p), err)
		}
	}
	return err
}

func (p *ReplicaDiskMigrateResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReplicaDiskMigrateResponse(%+v)", *p)
}

// Attributes:
//  - DiskStr
type AddNewDiskRequest struct {
	DiskStr string `thrift:"disk_str,1" db:"disk_str" json:"disk_str"`
}

func NewAddNewDiskRequest() *AddNewDiskRequest {
	return &AddNewDiskRequest{}
}

func (p *AddNewDiskRequest) GetDiskStr() string {
	return p.DiskStr
}
func (p *AddNewDiskRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *AddNewDiskRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.DiskStr = v
	}
	return nil
}

func (p *AddNewDiskRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("add_new_disk_request"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AddNewDiskRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("disk_str", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:disk_str: ", p), err)
	}
	if err := oprot.WriteString(string(p.DiskStr)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.disk_str (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:disk_str: ", p), err)
	}
	return err
}

func (p *AddNewDiskRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AddNewDiskRequest(%+v)", *p)
}

// Attributes:
//  - Err
//  - ErrHint
type AddNewDiskResponse struct {
	Err     *base.ErrorCode `thrift:"err,1" db:"err" json:"err"`
	ErrHint *string         `thrift:"err_hint,2" db:"err_hint" json:"err_hint,omitempty"`
}

func NewAddNewDiskResponse() *AddNewDiskResponse {
	return &AddNewDiskResponse{}
}

var AddNewDiskResponse_Err_DEFAULT *base.ErrorCode

func (p *AddNewDiskResponse) GetErr() *base.ErrorCode {
	if !p.IsSetErr() {
		return AddNewDiskResponse_Err_DEFAULT
	}
	return p.Err
}

var AddNewDiskResponse_ErrHint_DEFAULT string

func (p *AddNewDiskResponse) GetErrHint() string {
	if !p.IsSetErrHint() {
		return AddNewDiskResponse_ErrHint_DEFAULT
	}
	return *p.ErrHint
}
func (p *AddNewDiskResponse) IsSetErr() bool {
	return p.Err != nil
}

func (p *AddNewDiskResponse) IsSetErrHint() bool {
	return p.ErrHint != nil
}

func (p *AddNewDiskResponse) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *AddNewDiskResponse) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &base.ErrorCode{}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *AddNewDiskResponse) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.ErrHint = &v
	}
	return nil
}

func (p *AddNewDiskResponse) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("add_new_disk_response"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AddNewDiskResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
	}
	if err := p.Err.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
	}
	return err
}

func (p *AddNewDiskResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetErrHint() {
		if err := oprot.WriteFieldBegin("err_hint", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:err_hint: ", p), err)
		}
		if err := oprot.WriteString(string(*p.ErrHint)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.err_hint (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:err_hint: ", p), err)
		}
	}
	return err
}

func (p *AddNewDiskResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AddNewDiskResponse(%+v)", *p)
}

type ReplicaClient interface {
	// Parameters:
	//  - Req
	QueryDiskInfo(ctx context.Context, req *QueryDiskInfoRequest) (r *QueryDiskInfoResponse, err error)
	// Parameters:
	//  - Req
	DiskMigrate(ctx context.Context, req *ReplicaDiskMigrateRequest) (r *ReplicaDiskMigrateResponse, err error)
	// Parameters:
	//  - Req
	AddDisk(ctx context.Context, req *AddNewDiskRequest) (r *AddNewDiskResponse, err error)
}

type ReplicaClientClient struct {
	c thrift.TClient
}

func NewReplicaClientClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *ReplicaClientClient {
	return &ReplicaClientClient{
		c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
	}
}

func NewReplicaClientClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *ReplicaClientClient {
	return &ReplicaClientClient{
		c: thrift.NewTStandardClient(iprot, oprot),
	}
}

func NewReplicaClientClient(c thrift.TClient) *ReplicaClientClient {
	return &ReplicaClientClient{
		c: c,
	}
}

func (p *ReplicaClientClient) Client_() thrift.TClient {
	return p.c
}

// Parameters:
//  - Req
func (p *ReplicaClientClient) QueryDiskInfo(ctx context.Context, req *QueryDiskInfoRequest) (r *QueryDiskInfoResponse, err error) {
	var _args7 ReplicaClientQueryDiskInfoArgs
	_args7.Req = req
	var _result8 ReplicaClientQueryDiskInfoResult
	if err = p.Client_().Call(ctx, "query_disk_info", &_args7, &_result8); err != nil {
		return
	}
	return _result8.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *ReplicaClientClient) DiskMigrate(ctx context.Context, req *ReplicaDiskMigrateRequest) (r *ReplicaDiskMigrateResponse, err error) {
	var _args9 ReplicaClientDiskMigrateArgs
	_args9.Req = req
	var _result10 ReplicaClientDiskMigrateResult
	if err = p.Client_().Call(ctx, "disk_migrate", &_args9, &_result10); err != nil {
		return
	}
	return _result10.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *ReplicaClientClient) AddDisk(ctx context.Context, req *AddNewDiskRequest) (r *AddNewDiskResponse, err error) {
	var _args11 ReplicaClientAddDiskArgs
	_args11.Req = req
	var _result12 ReplicaClientAddDiskResult
	if err = p.Client_().Call(ctx, "add_disk", &_args11, &_result12); err != nil {
		return
	}
	return _result12.GetSuccess(), nil
}

type ReplicaClientProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      ReplicaClient
}

func (p *ReplicaClientProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *ReplicaClientProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *ReplicaClientProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewReplicaClientProcessor(handler ReplicaClient) *ReplicaClientProcessor {

	self13 := &ReplicaClientProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self13.processorMap["query_disk_info"] = &replicaClientProcessorQueryDiskInfo{handler: handler}
	self13.processorMap["disk_migrate"] = &replicaClientProcessorDiskMigrate{handler: handler}
	self13.processorMap["add_disk"] = &replicaClientProcessorAddDisk{handler: handler}
	return self13
}

func (p *ReplicaClientProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return false, err
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(ctx, seqId, iprot, oprot)
	}
	iprot.Skip(thrift.STRUCT)
	iprot.ReadMessageEnd()
	x14 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(name, thrift.EXCEPTION, seqId)
	x14.Write(oprot)
	oprot.WriteMessageEnd()
	oprot.Flush(ctx)
	return false, x14

}

type replicaClientProcessorQueryDiskInfo struct {
	handler ReplicaClient
}

func (p *replicaClientProcessorQueryDiskInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ReplicaClientQueryDiskInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("query_disk_info", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ReplicaClientQueryDiskInfoResult{}
	var retval *QueryDiskInfoResponse
	var err2 error
	if retval, err2 = p.handler.QueryDiskInfo(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing query_disk_info: "+err2.Error())
		oprot.WriteMessageBegin("query_disk_info", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("query_disk_info", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type replicaClientProcessorDiskMigrate struct {
	handler ReplicaClient
}

func (p *replicaClientProcessorDiskMigrate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ReplicaClientDiskMigrateArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("disk_migrate", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ReplicaClientDiskMigrateResult{}
	var retval *ReplicaDiskMigrateResponse
	var err2 error
	if retval, err2 = p.handler.DiskMigrate(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing disk_migrate: "+err2.Error())
		oprot.WriteMessageBegin("disk_migrate", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("disk_migrate", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type replicaClientProcessorAddDisk struct {
	handler ReplicaClient
}

func (p *replicaClientProcessorAddDisk) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ReplicaClientAddDiskArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("add_disk", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ReplicaClientAddDiskResult{}
	var retval *AddNewDiskResponse
	var err2 error
	if retval, err2 = p.handler.AddDisk(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing add_disk: "+err2.Error())
		oprot.WriteMessageBegin("add_disk", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("add_disk", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Req
type ReplicaClientQueryDiskInfoArgs struct {
	Req *QueryDiskInfoRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewReplicaClientQueryDiskInfoArgs() *ReplicaClientQueryDiskInfoArgs {
	return &ReplicaClientQueryDiskInfoArgs{}
}

var ReplicaClientQueryDiskInfoArgs_Req_DEFAULT *QueryDiskInfoRequest

func (p *ReplicaClientQueryDiskInfoArgs) GetReq() *QueryDiskInfoRequest {
	if !p.IsSetReq() {
		return ReplicaClientQueryDiskInfoArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *ReplicaClientQueryDiskInfoArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *ReplicaClientQueryDiskInfoArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ReplicaClientQueryDiskInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &QueryDiskInfoRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *ReplicaClientQueryDiskInfoArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("query_disk_info_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ReplicaClientQueryDiskInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *ReplicaClientQueryDiskInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReplicaClientQueryDiskInfoArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ReplicaClientQueryDiskInfoResult struct {
	Success *QueryDiskInfoResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewReplicaClientQueryDiskInfoResult() *ReplicaClientQueryDiskInfoResult {
	return &ReplicaClientQueryDiskInfoResult{}
}

var ReplicaClientQueryDiskInfoResult_Success_DEFAULT *QueryDiskInfoResponse

func (p *ReplicaClientQueryDiskInfoResult) GetSuccess() *QueryDiskInfoResponse {
	if !p.IsSetSuccess() {
		return ReplicaClientQueryDiskInfoResult_Success_DEFAULT
	}
	return p.Success
}
func (p *ReplicaClientQueryDiskInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ReplicaClientQueryDiskInfoResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ReplicaClientQueryDiskInfoResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &QueryDiskInfoResponse{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ReplicaClientQueryDiskInfoResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("query_disk_info_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ReplicaClientQueryDiskInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ReplicaClientQueryDiskInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReplicaClientQueryDiskInfoResult(%+v)", *p)
}

// Attributes:
//  - Req
type ReplicaClientDiskMigrateArgs struct {
	Req *ReplicaDiskMigrateRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewReplicaClientDiskMigrateArgs() *ReplicaClientDiskMigrateArgs {
	return &ReplicaClientDiskMigrateArgs{}
}

var ReplicaClientDiskMigrateArgs_Req_DEFAULT *ReplicaDiskMigrateRequest

func (p *ReplicaClientDiskMigrateArgs) GetReq() *ReplicaDiskMigrateRequest {
	if !p.IsSetReq() {
		return ReplicaClientDiskMigrateArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *ReplicaClientDiskMigrateArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *ReplicaClientDiskMigrateArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ReplicaClientDiskMigrateArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &ReplicaDiskMigrateRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *ReplicaClientDiskMigrateArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("disk_migrate_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ReplicaClientDiskMigrateArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *ReplicaClientDiskMigrateArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReplicaClientDiskMigrateArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ReplicaClientDiskMigrateResult struct {
	Success *ReplicaDiskMigrateResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewReplicaClientDiskMigrateResult() *ReplicaClientDiskMigrateResult {
	return &ReplicaClientDiskMigrateResult{}
}

var ReplicaClientDiskMigrateResult_Success_DEFAULT *ReplicaDiskMigrateResponse

func (p *ReplicaClientDiskMigrateResult) GetSuccess() *ReplicaDiskMigrateResponse {
	if !p.IsSetSuccess() {
		return ReplicaClientDiskMigrateResult_Success_DEFAULT
	}
	return p.Success
}
func (p *ReplicaClientDiskMigrateResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ReplicaClientDiskMigrateResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ReplicaClientDiskMigrateResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &ReplicaDiskMigrateResponse{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ReplicaClientDiskMigrateResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("disk_migrate_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ReplicaClientDiskMigrateResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ReplicaClientDiskMigrateResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReplicaClientDiskMigrateResult(%+v)", *p)
}

// Attributes:
//  - Req
type ReplicaClientAddDiskArgs struct {
	Req *AddNewDiskRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewReplicaClientAddDiskArgs() *ReplicaClientAddDiskArgs {
	return &ReplicaClientAddDiskArgs{}
}

var ReplicaClientAddDiskArgs_Req_DEFAULT *AddNewDiskRequest

func (p *ReplicaClientAddDiskArgs) GetReq() *AddNewDiskRequest {
	if !p.IsSetReq() {
		return ReplicaClientAddDiskArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *ReplicaClientAddDiskArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *ReplicaClientAddDiskArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ReplicaClientAddDiskArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &AddNewDiskRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *ReplicaClientAddDiskArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("add_disk_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ReplicaClientAddDiskArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *ReplicaClientAddDiskArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReplicaClientAddDiskArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ReplicaClientAddDiskResult struct {
	Success *AddNewDiskResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewReplicaClientAddDiskResult() *ReplicaClientAddDiskResult {
	return &ReplicaClientAddDiskResult{}
}

var ReplicaClientAddDiskResult_Success_DEFAULT *AddNewDiskResponse

func (p *ReplicaClientAddDiskResult) GetSuccess() *AddNewDiskResponse {
	if !p.IsSetSuccess() {
		return ReplicaClientAddDiskResult_Success_DEFAULT
	}
	return p.Success
}
func (p *ReplicaClientAddDiskResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ReplicaClientAddDiskResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ReplicaClientAddDiskResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &AddNewDiskResponse{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ReplicaClientAddDiskResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("add_disk_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ReplicaClientAddDiskResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ReplicaClientAddDiskResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReplicaClientAddDiskResult(%+v)", *p)
}
