/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.Principal;

@ApiModel(description="A list of Principals")
public class Principals {
    @NotNull
    @Valid
    private final @NotNull @Valid List<@Valid Principal> principals;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="principals", required=true)
    public List<@Valid Principal> getPrincipals() {
        return this.principals;
    }

    @JsonCreator
    public Principals(@JsonProperty(value="principals", required=true) List<@Valid Principal> principals) {
        this.principals = Objects.requireNonNullElse(principals, new ArrayList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(List<@Valid Principal> principals) {
        return new Builder(principals);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Principals principals = (Principals)o;
        return Objects.equals(this.principals, principals.principals);
    }

    public int hashCode() {
        return Objects.hash(this.principals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Principals {\n");
        sb.append("    principals: ").append(this.toIndentedString(this.principals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private List<@Valid Principal> principals;

        private Builder() {
        }

        private Builder(List<@Valid Principal> principals) {
            this.principals = Objects.requireNonNullElse(principals, new ArrayList());
        }

        public Builder setPrincipals(List<@Valid Principal> principals) {
            this.principals = principals;
            return this;
        }

        public Principals build() {
            Principals inst = new Principals(this.principals);
            return inst;
        }
    }
}

