/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.datalake.models.LeaseDurationType;
import com.azure.storage.file.datalake.models.LeaseStateType;
import com.azure.storage.file.datalake.models.LeaseStatusType;
import com.azure.storage.file.datalake.models.PublicAccessType;
import java.time.OffsetDateTime;

public final class FileSystemItemProperties {
    private DateTimeRfc1123 lastModified;
    private String eTag;
    private LeaseStatusType leaseStatus;
    private LeaseStateType leaseState;
    private LeaseDurationType leaseDuration;
    private PublicAccessType publicAccess;
    private Boolean hasImmutabilityPolicy;
    private Boolean hasLegalHold;
    private String encryptionScope;
    private Boolean encryptionScopeOverridePrevented;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FileSystemItemProperties setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public FileSystemItemProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public FileSystemItemProperties setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public FileSystemItemProperties setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public FileSystemItemProperties setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public PublicAccessType getPublicAccess() {
        return this.publicAccess;
    }

    public FileSystemItemProperties setPublicAccess(PublicAccessType publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    public Boolean hasImmutabilityPolicy() {
        return this.hasImmutabilityPolicy;
    }

    public FileSystemItemProperties setHasImmutabilityPolicy(Boolean hasImmutabilityPolicy) {
        this.hasImmutabilityPolicy = hasImmutabilityPolicy;
        return this;
    }

    public Boolean hasLegalHold() {
        return this.hasLegalHold;
    }

    public FileSystemItemProperties setHasLegalHold(Boolean hasLegalHold) {
        this.hasLegalHold = hasLegalHold;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public FileSystemItemProperties setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    public Boolean isEncryptionScopeOverridePrevented() {
        return this.encryptionScopeOverridePrevented;
    }

    public FileSystemItemProperties setEncryptionScopeOverridePrevented(Boolean encryptionScopeOverridePrevented) {
        this.encryptionScopeOverridePrevented = encryptionScopeOverridePrevented;
        return this;
    }
}

