/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog;

import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public enum AccessDelegationMode {
    UNKNOWN("unknown"),
    VENDED_CREDENTIALS("vended-credentials"),
    REMOTE_SIGNING("remote-signing");

    private final String protocolValue;

    private AccessDelegationMode(String protocolValue) {
        this.protocolValue = protocolValue;
    }

    public String protocolValue() {
        return this.protocolValue;
    }

    public static EnumSet<AccessDelegationMode> fromProtocolValuesList(String protocolValues) {
        if (protocolValues == null || protocolValues.isEmpty()) {
            return EnumSet.noneOf(AccessDelegationMode.class);
        }
        if (protocolValues.trim().toLowerCase(Locale.ROOT).equals("true")) {
            return EnumSet.of(VENDED_CREDENTIALS);
        }
        EnumSet<AccessDelegationMode> set = EnumSet.noneOf(AccessDelegationMode.class);
        Arrays.stream(protocolValues.split(",")).map(String::trim).map(n -> Mapper.byProtocolValue.getOrDefault(n, UNKNOWN)).forEach(set::add);
        return set;
    }

    private static class Mapper {
        private static final Map<String, AccessDelegationMode> byProtocolValue = Arrays.stream(AccessDelegationMode.values()).collect(Collectors.toMap(AccessDelegationMode::protocolValue, Functions.identity()));

        private Mapper() {
        }
    }
}

