/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;

public class PolarisBaseEntity
extends PolarisEntityCore {
    public static final String EMPTY_MAP_STRING = "{}";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    protected int subTypeCode;
    protected long createTimestamp;
    protected long dropTimestamp;
    protected long purgeTimestamp;
    protected long toPurgeTimestamp;
    protected long lastUpdateTimestamp;
    protected String properties;
    protected String internalProperties;
    protected int grantRecordsVersion;

    public int getSubTypeCode() {
        return this.subTypeCode;
    }

    public void setSubTypeCode(int subTypeCode) {
        this.subTypeCode = subTypeCode;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public long getDropTimestamp() {
        return this.dropTimestamp;
    }

    public void setDropTimestamp(long dropTimestamp) {
        this.dropTimestamp = dropTimestamp;
    }

    public long getPurgeTimestamp() {
        return this.purgeTimestamp;
    }

    public void setPurgeTimestamp(long purgeTimestamp) {
        this.purgeTimestamp = purgeTimestamp;
    }

    public long getToPurgeTimestamp() {
        return this.toPurgeTimestamp;
    }

    public void setToPurgeTimestamp(long toPurgeTimestamp) {
        this.toPurgeTimestamp = toPurgeTimestamp;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public void setLastUpdateTimestamp(long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    public String getProperties() {
        return this.properties != null ? this.properties : EMPTY_MAP_STRING;
    }

    @JsonIgnore
    public Map<String, String> getPropertiesAsMap() {
        if (this.properties == null) {
            return new HashMap<String, String>();
        }
        try {
            return (Map)MAPPER.readValue(this.properties, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(String.format("Failed to deserialize json. properties %s", this.properties), ex);
        }
    }

    public void addProperty(String propName, String propValue) {
        Map<String, String> props = this.getPropertiesAsMap();
        props.put(propName, propValue);
        this.setPropertiesAsMap(props);
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    @JsonIgnore
    public void setPropertiesAsMap(Map<String, String> properties) {
        try {
            this.properties = properties == null ? null : MAPPER.writeValueAsString(properties);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(String.format("Failed to serialize json. properties %s", properties), ex);
        }
    }

    public String getInternalProperties() {
        return this.internalProperties != null ? this.internalProperties : EMPTY_MAP_STRING;
    }

    @JsonIgnore
    public Map<String, String> getInternalPropertiesAsMap() {
        if (this.internalProperties == null) {
            return new HashMap<String, String>();
        }
        try {
            return (Map)MAPPER.readValue(this.internalProperties, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(String.format("Failed to deserialize json. internalProperties %s", this.internalProperties), ex);
        }
    }

    public void addInternalProperty(String propName, String propValue) {
        Map<String, String> props = this.getInternalPropertiesAsMap();
        props.put(propName, propValue);
        this.setInternalPropertiesAsMap(props);
    }

    public void setInternalProperties(String internalProperties) {
        this.internalProperties = internalProperties;
    }

    @JsonIgnore
    public void setInternalPropertiesAsMap(Map<String, String> internalProperties) {
        try {
            this.internalProperties = internalProperties == null ? null : MAPPER.writeValueAsString(internalProperties);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(String.format("Failed to serialize json. internalProperties %s", internalProperties), ex);
        }
    }

    public int getGrantRecordsVersion() {
        return this.grantRecordsVersion;
    }

    public void setGrantRecordsVersion(int grantRecordsVersion) {
        this.grantRecordsVersion = grantRecordsVersion;
    }

    public static PolarisBaseEntity fromCore(PolarisEntityCore coreEntity, PolarisEntityType entityType, PolarisEntitySubType subType) {
        return new PolarisBaseEntity(coreEntity.getCatalogId(), coreEntity.getId(), entityType, subType, coreEntity.getParentId(), coreEntity.getName());
    }

    public PolarisBaseEntity(PolarisBaseEntity entity) {
        super(entity.getCatalogId(), entity.getId(), entity.getParentId(), entity.getTypeCode(), entity.getName(), entity.getEntityVersion());
        this.subTypeCode = entity.getSubTypeCode();
        this.createTimestamp = entity.getCreateTimestamp();
        this.dropTimestamp = entity.getDropTimestamp();
        this.purgeTimestamp = entity.getPurgeTimestamp();
        this.toPurgeTimestamp = entity.getToPurgeTimestamp();
        this.lastUpdateTimestamp = entity.getLastUpdateTimestamp();
        this.properties = entity.getProperties();
        this.internalProperties = entity.getInternalProperties();
        this.grantRecordsVersion = entity.getGrantRecordsVersion();
    }

    public PolarisBaseEntity(long catalogId, long id, PolarisEntityType type, PolarisEntitySubType subType, long parentId, String name) {
        this(catalogId, id, type.getCode(), subType.getCode(), parentId, name);
    }

    protected PolarisBaseEntity(long catalogId, long id, int typeCode, int subTypeCode, long parentId, String name) {
        super(catalogId, id, parentId, typeCode, name, 1);
        this.subTypeCode = subTypeCode;
        this.createTimestamp = System.currentTimeMillis();
        this.dropTimestamp = 0L;
        this.purgeTimestamp = 0L;
        this.toPurgeTimestamp = 0L;
        this.lastUpdateTimestamp = this.createTimestamp;
        this.properties = null;
        this.internalProperties = null;
        this.grantRecordsVersion = 1;
    }

    protected PolarisBaseEntity() {
    }

    @JsonIgnore
    public PolarisEntitySubType getSubType() {
        return PolarisEntitySubType.fromCode(this.subTypeCode);
    }

    @JsonIgnore
    public boolean isDropped() {
        return this.dropTimestamp != 0L;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolarisBaseEntity)) {
            return false;
        }
        PolarisBaseEntity that = (PolarisBaseEntity)o;
        return this.subTypeCode == that.subTypeCode && this.createTimestamp == that.createTimestamp && this.dropTimestamp == that.dropTimestamp && this.purgeTimestamp == that.purgeTimestamp && this.toPurgeTimestamp == that.toPurgeTimestamp && this.lastUpdateTimestamp == that.lastUpdateTimestamp && this.grantRecordsVersion == that.grantRecordsVersion && Objects.equals(this.properties, that.properties) && Objects.equals(this.internalProperties, that.internalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalogId, this.id, this.parentId, this.typeCode, this.name, this.entityVersion, this.subTypeCode, this.createTimestamp, this.dropTimestamp, this.purgeTimestamp, this.toPurgeTimestamp, this.lastUpdateTimestamp, this.properties, this.internalProperties, this.grantRecordsVersion);
    }

    @Override
    public String toString() {
        return "PolarisBaseEntity{" + super.toString() + ", subTypeCode=" + this.subTypeCode + ", createTimestamp=" + this.createTimestamp + ", dropTimestamp=" + this.dropTimestamp + ", purgeTimestamp=" + this.purgeTimestamp + ", toPurgeTimestamp=" + this.toPurgeTimestamp + ", lastUpdateTimestamp=" + this.lastUpdateTimestamp + ", grantRecordsVersion=" + this.grantRecordsVersion + "}";
    }
}

