/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import java.util.Optional;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnEncoding;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnUtil;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;

public class LongColumn
implements Column {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(LongColumn.class);
    public static final int SIZE_IN_BYTES_PER_POSITION = 9;
    private final int arrayOffset;
    private final int positionCount;
    private final boolean[] valueIsNull;
    private final long[] values;
    private final long retainedSizeInBytes;

    public LongColumn(int positionCount, Optional<boolean[]> valueIsNull, long[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    LongColumn(int arrayOffset, int positionCount, boolean[] valueIsNull, long[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOfLongArray((int)positionCount) + RamUsageEstimator.sizeOfBooleanArray((int)positionCount);
    }

    public TSDataType getDataType() {
        return TSDataType.INT64;
    }

    public ColumnEncoding getEncoding() {
        return ColumnEncoding.INT64_ARRAY;
    }

    public long getLong(int position) {
        return this.values[position + this.arrayOffset];
    }

    public long[] getLongs() {
        return this.values;
    }

    public Object getObject(int position) {
        return this.getLong(position);
    }

    public TsPrimitiveType getTsPrimitiveType(int position) {
        return new TsPrimitiveType.TsLong(this.getLong(position));
    }

    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    public boolean isNull(int position) {
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    public boolean[] isNull() {
        if (this.valueIsNull == null) {
            boolean[] res = new boolean[this.positionCount];
            Arrays.fill(res, false);
            return res;
        }
        return this.valueIsNull;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new LongColumn(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    public Column getRegionCopy(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        int from = positionOffset + this.arrayOffset;
        int to = from + length;
        boolean[] valueIsNullCopy = this.valueIsNull != null ? Arrays.copyOfRange(this.valueIsNull, from, to) : null;
        long[] valuesCopy = Arrays.copyOfRange(this.values, from, to);
        return new LongColumn(0, length, valueIsNullCopy, valuesCopy);
    }

    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new LongColumn(this.arrayOffset + fromIndex, this.positionCount - fromIndex, this.valueIsNull, this.values);
    }

    public Column subColumnCopy(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        int from = this.arrayOffset + fromIndex;
        boolean[] valueIsNullCopy = this.valueIsNull != null ? Arrays.copyOfRange(this.valueIsNull, from, this.positionCount) : null;
        long[] valuesCopy = Arrays.copyOfRange(this.values, from, this.positionCount);
        int length = this.positionCount - fromIndex;
        return new LongColumn(0, length, valueIsNullCopy, valuesCopy);
    }

    public void reverse() {
        int j;
        int i = this.arrayOffset;
        for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
            long valueTmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = valueTmp;
        }
        if (this.valueIsNull != null) {
            i = this.arrayOffset;
            for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
                boolean isNullTmp = this.valueIsNull[i];
                this.valueIsNull[i] = this.valueIsNull[j];
                this.valueIsNull[j] = isNullTmp;
            }
        }
    }

    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }
}

