/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util.validation;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.eclipse.milo.opcua.stack.core.util.validation.ValidationCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaCertificateValidityChecker
extends PKIXCertPathChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcUaCertificateValidityChecker.class);
    private X500Principal previousSubject;
    private PublicKey previousPublicKey;
    private final CertPath certPath;
    private final TrustAnchor trustAnchor;
    private final Set<ValidationCheck> validationChecks;

    public OpcUaCertificateValidityChecker(CertPath certPath, TrustAnchor trustAnchor, Set<ValidationCheck> validationChecks) {
        this.certPath = certPath;
        this.trustAnchor = trustAnchor;
        this.validationChecks = validationChecks;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (!forward) {
            if (this.trustAnchor.getTrustedCert() != null) {
                this.previousPublicKey = this.trustAnchor.getTrustedCert().getPublicKey();
                this.previousSubject = this.trustAnchor.getTrustedCert().getSubjectX500Principal();
            } else {
                this.previousPublicKey = this.trustAnchor.getCAPublicKey();
                this.previousSubject = this.trustAnchor.getCA();
            }
        } else {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        X509Certificate certificate = (X509Certificate)cert;
        try {
            this.verifyValidity(certificate);
            this.verifyNameChaining(certificate);
            this.verifySignature(certificate);
        }
        catch (CertPathValidatorException e) {
            if (this.validationChecks.contains((Object)ValidationCheck.VALIDITY)) {
                throw e;
            }
            LOGGER.warn("check suppressed: certificate failed validity check: {}", (Object)certificate.getSubjectX500Principal().getName());
        }
        this.updateInternalState(certificate);
    }

    private void updateInternalState(X509Certificate certificate) {
        this.previousPublicKey = certificate.getPublicKey();
        this.previousSubject = certificate.getSubjectX500Principal();
    }

    private void verifyValidity(X509Certificate certificate) throws CertPathValidatorException {
        try {
            certificate.checkValidity(new Date());
        }
        catch (CertificateExpiredException e) {
            throw new CertPathValidatorException("validity check failed (expired)", e, null, this.certPath.getCertificates().indexOf(certificate), CertPathValidatorException.BasicReason.EXPIRED);
        }
        catch (CertificateNotYetValidException e) {
            throw new CertPathValidatorException("validity check failed (not yet valid)", e, null, this.certPath.getCertificates().indexOf(certificate), CertPathValidatorException.BasicReason.NOT_YET_VALID);
        }
    }

    private void verifyNameChaining(X509Certificate certificate) throws CertPathValidatorException {
        if (this.previousSubject != null) {
            X500Principal issuer = certificate.getIssuerX500Principal();
            if (issuer.getName() == null || issuer.getName().isEmpty()) {
                throw new CertPathValidatorException("subject/issuer name chaining check failed: null/empty issuer DN", null, null, this.certPath.getCertificates().indexOf(certificate), PKIXReason.NAME_CHAINING);
            }
            if (!Objects.equals(issuer, this.previousSubject)) {
                throw new CertPathValidatorException("subject/issuer name chaining check failed", null, null, this.certPath.getCertificates().indexOf(certificate), PKIXReason.NAME_CHAINING);
            }
        }
    }

    private void verifySignature(X509Certificate certificate) throws CertPathValidatorException {
        try {
            certificate.verify(this.previousPublicKey);
        }
        catch (SignatureException e) {
            throw new CertPathValidatorException("signature check failed", e, null, this.certPath.getCertificates().indexOf(certificate), CertPathValidatorException.BasicReason.INVALID_SIGNATURE);
        }
        catch (GeneralSecurityException e) {
            throw new CertPathValidatorException("signature check failed", e);
        }
    }
}

