/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.scheduler;

import java.util.concurrent.LinkedBlockingDeque;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.scheduler.AbstractProcedureScheduler;

public class SimpleProcedureScheduler
extends AbstractProcedureScheduler {
    private final LinkedBlockingDeque<Procedure> runnables = new LinkedBlockingDeque();
    private final LinkedBlockingDeque<Procedure> waitings = new LinkedBlockingDeque();

    @Override
    protected void enqueue(Procedure procedure, boolean addFront) {
        if (addFront) {
            this.runnables.addFirst(procedure);
        } else {
            this.runnables.addLast(procedure);
        }
    }

    @Override
    protected Procedure dequeue() {
        return this.runnables.poll();
    }

    @Override
    public void clear() {
        this.schedLock();
        try {
            this.runnables.clear();
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public void yield(Procedure proc) {
        this.addBack(proc);
    }

    @Override
    public boolean queueHasRunnables() {
        return !this.runnables.isEmpty();
    }

    @Override
    public int queueSize() {
        return this.runnables.size();
    }

    public void addWaiting(Procedure proc) {
        this.waitings.add(proc);
    }

    public void releaseWaiting() {
        this.runnables.addAll(this.waitings);
        this.waitings.clear();
    }
}

