/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.utils.IOUtils;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMCommonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JVMCommonUtils.class);
    public static final int MAX_EXECUTOR_POOL_SIZE = Math.max(100, JVMCommonUtils.getCpuCores() * 5);
    private static final int CPUS = Runtime.getRuntime().availableProcessors();
    private static final double diskSpaceWarningThreshold = CommonDescriptor.getInstance().getConfig().getDiskSpaceWarningThreshold();

    public static int getJdkVersion() {
        String[] javaVersionElements = System.getProperty("java.version").split("-")[0].split("\\.");
        if (Integer.parseInt(javaVersionElements[0]) == 1) {
            return Integer.parseInt(javaVersionElements[1]);
        }
        return Integer.parseInt(javaVersionElements[0]);
    }

    public static long getUsableSpace(String dir) {
        File dirFile = FSFactoryProducer.getFSFactory().getFile(dir);
        dirFile.mkdirs();
        return IOUtils.retryNoException(5, 2000L, dirFile::getFreeSpace, space -> space > 0L).orElse(0L);
    }

    public static double getDiskFreeRatio(String dir) {
        long totalSpace;
        double ratio;
        long freeSpace;
        File dirFile = new File(dir);
        if (!dirFile.mkdirs()) {
            dirFile = new File(dir);
        }
        if ((freeSpace = IOUtils.retryNoException(5, 2000L, dirFile::getFreeSpace, space -> space > 0L).orElse(0L).longValue()) == 0L) {
            LOGGER.warn("Cannot get free space for {} after retries, please check the disk status", (Object)dir);
        }
        if ((ratio = 1.0 * (double)freeSpace / (double)(totalSpace = dirFile.getTotalSpace())) <= diskSpaceWarningThreshold) {
            LOGGER.warn("{} is above the warning threshold, free space {}, total space {}", new Object[]{dir, freeSpace, totalSpace});
        }
        return ratio;
    }

    public static boolean hasSpace(String dir) {
        return JVMCommonUtils.getDiskFreeRatio(dir) > diskSpaceWarningThreshold;
    }

    public static long getOccupiedSpace(String folderPath) throws IOException {
        Path folder = Paths.get(folderPath, new String[0]);
        try (Stream<Path> s = Files.walk(folder, new FileVisitOption[0]);){
            long l = s.filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
            return l;
        }
    }

    public static int getCpuCores() {
        return CPUS;
    }

    public static int getMaxExecutorPoolSize() {
        return MAX_EXECUTOR_POOL_SIZE;
    }
}

