/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.query.timegenerator;

import java.io.IOException;
import java.util.List;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.controller.IMetadataQuerier;
import org.apache.tsfile.read.expression.IExpression;
import org.apache.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.tsfile.read.reader.IBatchReader;
import org.apache.tsfile.read.reader.series.FileSeriesReader;

public class TsFileTimeGenerator
extends TimeGenerator {
    private IChunkLoader chunkLoader;
    private IMetadataQuerier metadataQuerier;

    public TsFileTimeGenerator(IExpression iexpression, IChunkLoader chunkLoader, IMetadataQuerier metadataQuerier) throws IOException {
        this.chunkLoader = chunkLoader;
        this.metadataQuerier = metadataQuerier;
        super.constructNode(iexpression);
    }

    @Override
    protected IBatchReader generateNewBatchReader(SingleSeriesExpression expression) throws IOException {
        List<IChunkMetadata> chunkMetadataList = this.metadataQuerier.getChunkMetaDataList(expression.getSeriesPath());
        return new FileSeriesReader(this.chunkLoader, chunkMetadataList, expression.getFilter());
    }

    @Override
    protected boolean isAscending() {
        return true;
    }

    @Override
    public Filter getTimeFilter() {
        return null;
    }
}

