/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class RegularTransformer
extends UnaryTransformer {
    private final Pattern pattern;

    public RegularTransformer(LayerReader layerReader, Pattern pattern) {
        super(layerReader);
        this.pattern = pattern;
        if (this.layerReaderDataType != TSDataType.TEXT) {
            throw new UnSupportedDataTypeException("Unsupported data type: " + this.layerReaderDataType);
        }
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.BOOLEAN};
    }

    @Override
    protected void transform(Column[] columns, ColumnBuilder builder) throws QueryProcessException, IOException {
        int count = columns[0].getPositionCount();
        Binary[] binaries = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                boolean res = this.pattern.matcher(binaries[i].getStringValue(TSFileConfig.STRING_CHARSET)).find();
                builder.writeBoolean(res);
                continue;
            }
            builder.appendNull();
        }
    }
}

