/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.Objects;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnEncoding;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.BooleanColumnBuilder;
import org.apache.tsfile.read.common.block.column.ColumnUtil;
import org.apache.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.tsfile.read.common.block.column.FloatColumnBuilder;
import org.apache.tsfile.read.common.block.column.IntColumnBuilder;
import org.apache.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;

public class NullColumn
implements Column {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(BooleanColumn.class);
    private int positionCount;
    private final long retainedSizeInBytes;

    public NullColumn(int positionCount) {
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.retainedSizeInBytes = INSTANCE_SIZE;
    }

    @Override
    public TSDataType getDataType() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public ColumnEncoding getEncoding() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean mayHaveNull() {
        return true;
    }

    @Override
    public boolean isNull(int position) {
        return true;
    }

    @Override
    public boolean[] isNull() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new NullColumn(length);
    }

    @Override
    public Column getRegionCopy(int positionOffset, int length) {
        return this.getRegion(positionOffset, length);
    }

    @Override
    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new NullColumn(this.positionCount - fromIndex);
    }

    @Override
    public Column subColumnCopy(int fromIndex) {
        return this.subColumn(fromIndex);
    }

    @Override
    public Column getPositions(int[] positions, int offset, int length) {
        return this.copyPositions(positions, offset, length);
    }

    @Override
    public Column copyPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        for (int position : positions) {
            ColumnUtil.checkReadablePosition(this, position);
        }
        return new NullColumn(length);
    }

    @Override
    public void reverse() {
    }

    public static Column create(TSDataType dataType, int positionCount) {
        Objects.requireNonNull(dataType, "dataType is null");
        switch (dataType) {
            case BOOLEAN: {
                return new RunLengthEncodedColumn(BooleanColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case INT32: 
            case DATE: {
                return new RunLengthEncodedColumn(IntColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case INT64: 
            case TIMESTAMP: {
                return new RunLengthEncodedColumn(LongColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case FLOAT: {
                return new RunLengthEncodedColumn(FloatColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case DOUBLE: {
                return new RunLengthEncodedColumn(DoubleColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return new RunLengthEncodedColumn(BinaryColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + (Object)((Object)dataType));
    }

    @Override
    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public void setPositionCount(int count) {
        this.positionCount = count;
    }

    @Override
    public void setNull(int start, int end) {
    }
}

