/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.InstanceNode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceNode;

public class ViewNode
extends InstanceNode
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=279");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=281");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=280");
    private final Boolean containsNoLoops;
    private final UByte eventNotifier;

    public ViewNode(NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, ReferenceNode[] references, Boolean containsNoLoops, UByte eventNotifier) {
        super(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
        this.containsNoLoops = containsNoLoops;
        this.eventNotifier = eventNotifier;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getContainsNoLoops() {
        return this.containsNoLoops;
    }

    public UByte getEventNotifier() {
        return this.eventNotifier;
    }

    protected ViewNode(ViewNodeBuilder<?, ?> b) {
        super((InstanceNode.InstanceNodeBuilder<?, ?>)b);
        this.containsNoLoops = ((ViewNodeBuilder)b).containsNoLoops;
        this.eventNotifier = ((ViewNodeBuilder)b).eventNotifier;
    }

    public static ViewNodeBuilder<?, ?> builder() {
        return new ViewNodeBuilderImpl();
    }

    @Override
    public ViewNodeBuilder<?, ?> toBuilder() {
        return new ViewNodeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewNode)) {
            return false;
        }
        ViewNode other = (ViewNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$containsNoLoops = this.getContainsNoLoops();
        Boolean other$containsNoLoops = other.getContainsNoLoops();
        if (this$containsNoLoops == null ? other$containsNoLoops != null : !((Object)this$containsNoLoops).equals(other$containsNoLoops)) {
            return false;
        }
        UByte this$eventNotifier = this.getEventNotifier();
        UByte other$eventNotifier = other.getEventNotifier();
        return !(this$eventNotifier == null ? other$eventNotifier != null : !((Object)this$eventNotifier).equals(other$eventNotifier));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ViewNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $containsNoLoops = this.getContainsNoLoops();
        result = result * 59 + ($containsNoLoops == null ? 43 : ((Object)$containsNoLoops).hashCode());
        UByte $eventNotifier = this.getEventNotifier();
        result = result * 59 + ($eventNotifier == null ? 43 : ((Object)$eventNotifier).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ViewNode(containsNoLoops=" + this.getContainsNoLoops() + ", eventNotifier=" + this.getEventNotifier() + ")";
    }

    private static final class ViewNodeBuilderImpl
    extends ViewNodeBuilder<ViewNode, ViewNodeBuilderImpl> {
        private ViewNodeBuilderImpl() {
        }

        @Override
        protected ViewNodeBuilderImpl self() {
            return this;
        }

        @Override
        public ViewNode build() {
            return new ViewNode(this);
        }
    }

    public static abstract class ViewNodeBuilder<C extends ViewNode, B extends ViewNodeBuilder<C, B>>
    extends InstanceNode.InstanceNodeBuilder<C, B> {
        private Boolean containsNoLoops;
        private UByte eventNotifier;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ViewNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ViewNode instance, ViewNodeBuilder<?, ?> b) {
            b.containsNoLoops(instance.containsNoLoops);
            b.eventNotifier(instance.eventNotifier);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B containsNoLoops(Boolean containsNoLoops) {
            this.containsNoLoops = containsNoLoops;
            return (B)this.self();
        }

        public B eventNotifier(UByte eventNotifier) {
            this.eventNotifier = eventNotifier;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ViewNode.ViewNodeBuilder(super=" + super.toString() + ", containsNoLoops=" + this.containsNoLoops + ", eventNotifier=" + this.eventNotifier + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ViewNode> {
        @Override
        public Class<ViewNode> getType() {
            return ViewNode.class;
        }

        @Override
        public ViewNode decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeClass nodeClass = decoder.readEnum("NodeClass", NodeClass.class);
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            ReferenceNode[] references = (ReferenceNode[])decoder.readStructArray("References", ReferenceNode.TYPE_ID);
            Boolean containsNoLoops = decoder.readBoolean("ContainsNoLoops");
            UByte eventNotifier = decoder.readByte("EventNotifier");
            return new ViewNode(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references, containsNoLoops, eventNotifier);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ViewNode value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("NodeClass", value.getNodeClass());
            encoder.writeQualifiedName("BrowseName", value.getBrowseName());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeStructArray("References", (Object[])value.getReferences(), ReferenceNode.TYPE_ID);
            encoder.writeBoolean("ContainsNoLoops", value.getContainsNoLoops());
            encoder.writeByte("EventNotifier", value.getEventNotifier());
        }
    }
}

